/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fitlibrary.exception.table.NestedTableExpectedException;
import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.runResults.TestResults;
import fitlibrary.spec.SpecifyFixture;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;

public class SpecifySuiteFixture
extends SpecifyFixture {
    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
            Row row = (Row)table.at(rowNo);
            if (row.size() < 2) {
                row.error(testResults, new RowWrongWidthException(2));
            }
            Cell testCell = (Cell)row.at(0);
            Cell reportCell = (Cell)row.at(1);
            if (!testCell.hasEmbeddedTables(this)) {
                row.error(testResults, new NestedTableExpectedException());
                return null;
            }
            Tables actualTables = testCell.getEmbeddedTables();
            Tables expectedTables = reportCell.getEmbeddedTables();
            this.runner.doStorytest(actualTables);
            if (this.tablesCompare.tablesEqual("", actualTables, expectedTables)) {
                reportCell.pass(testResults);
                testResults.addRights(this.cellCount(actualTables) - 1);
                continue;
            }
            reportCell.fail(testResults);
            this.errorReport.actualResult(actualTables);
        }
        return null;
    }
}

