/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Fixture;
import fit.Parse;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.table.SingleNestedTableExpected;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.table.TablesOnList;
import fitlibrary.utility.HtmlUtils;
import fitlibrary.utility.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellOnList
extends TablesOnList
implements Cell {
    static final Pattern COLSPAN_PATTERN = Pattern.compile(".*\\b(colspan\\s*=\\s*\"?\\s*(\\d+)\\s*\"?).*");
    private boolean cellIsInHiddenRow = false;
    private String fullText = "";

    public CellOnList() {
        super("td");
    }

    public CellOnList(String cellText) {
        this();
        this.fullText = cellText;
    }

    public CellOnList(Cell cell) {
        this(cell.fullText());
        this.setInnerTables(cell.getEmbeddedTables());
    }

    public CellOnList(Tables tables) {
        this();
        this.addTables(tables);
    }

    public CellOnList(String preamble, Tables tables) {
        this(tables);
        this.addToStartOfLeader(Fixture.label(preamble));
    }

    @Override
    public void setText(String text) {
        this.fullText = text;
    }

    @Override
    public String text(VariableResolver resolver) {
        Pair<String, Tables> resolve = resolver.resolve(this.fullText);
        this.addTables((Tables)resolve.second);
        if (!this.fullText.equals(resolve.first)) {
            this.fullText = (String)resolve.first;
        }
        return this.text();
    }

    @Override
    public String text() {
        return Parse.unescape(Parse.unformat(this.fullText)).trim();
    }

    @Override
    public boolean unresolved(VariableResolver resolver) {
        return this.text().startsWith("@{") && this.text().indexOf("}") == this.text().length() - 1 && this.text().equals(this.text(resolver));
    }

    @Override
    public String textLower(VariableResolver resolver) {
        return this.text(resolver).toLowerCase();
    }

    @Override
    public boolean matchesTextInLowerCase(String s, VariableResolver resolver) {
        return this.text(resolver).toLowerCase().equals(s.toLowerCase());
    }

    @Override
    public boolean isBlank(VariableResolver resolver) {
        return this.text(resolver).equals("");
    }

    @Override
    public Cell deepCopy() {
        Cell copy = TableFactory.cell(this.fullText);
        for (Table table : this) {
            copy.add(table.deepCopy());
        }
        copy.setLeader(this.getLeader());
        copy.setTrailer(this.getTrailer());
        copy.setTagLine(this.getTagLine());
        return copy;
    }

    @Override
    public void expectedElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(CellOnList.label("missing"));
    }

    @Override
    public void actualElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(CellOnList.label("surplus"));
    }

    @Override
    public void unexpected(TestResults testResults, String s) {
        this.fail(testResults);
        this.addToBody(CellOnList.label("unexpected " + s));
    }

    @Override
    public void actualElementMissing(TestResults testResults, String value) {
        this.fail(testResults);
        this.fullText = Fixture.gray(Fixture.escape(value.toString()));
        this.addToBody(CellOnList.label("surplus"));
    }

    @Override
    public void pass(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    @Override
    public void pass(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
        this.addToBody("<hr>" + Fixture.escape(msg) + CellOnList.label("actual"));
    }

    @Override
    public void fail(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    @Override
    public void fail(TestResults testResults, String msg, VariableResolver resolver) {
        this.fail(testResults);
        String resolved = "";
        if (!this.text().equals(this.text(resolver))) {
            resolved = " = " + this.text(resolver);
        }
        this.addToBody(resolved + CellOnList.label("expected") + "<hr>" + Fixture.escape(msg) + CellOnList.label("actual"));
    }

    @Override
    public void failWithStringEquals(TestResults testResults, String actual, VariableResolver resolver) {
        if (this.fullText.isEmpty() && !this.hasEmbeddedTables(resolver)) {
            this.failHtml(testResults, actual);
            return;
        }
        this.fail(testResults);
        String resolved = "";
        if (!this.text().equals(this.text(resolver))) {
            resolved = " = " + this.text(resolver);
        }
        this.addToBody(resolved + CellOnList.label("expected") + "<hr>" + Fixture.escape(actual) + CellOnList.label("actual") + CellOnList.differences(Fixture.escape(this.text(resolver)), Fixture.escape(actual)));
    }

    public static String differences(String actual, String expected) {
        return PlugBoard.stringDifferencing.differences(actual, expected);
    }

    @Override
    public void failHtml(TestResults testResults, String msg) {
        this.fail(testResults);
        this.addToBody(msg);
    }

    @Override
    public void error(TestResults testResults, Throwable e) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToBody(PlugBoard.exceptionHandling.exceptionMessage(e));
        this.addToTag("class=\"error\"");
        testResults.exception();
    }

    @Override
    public void error(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToBody("<hr/>" + Fixture.label(msg));
        this.addToTag("class=\"error\"");
        testResults.exception();
    }

    @Override
    public void error(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.addToTag("class=\"error\"");
        testResults.exception();
    }

    @Override
    public void ignore(TestResults testResults) {
        if (this.tagAnnotation.contains("bgcolor=#DADAFF")) {
            return;
        }
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        if (this.tagAnnotation.indexOf("class") >= 0) {
            throw new RuntimeException("Duplicate cell class in tag. Tag is already: " + this.tagAnnotation);
        }
        this.addToTag("class=\"ignore\"");
        testResults.ignore();
    }

    @Override
    public void exceptionExpected(boolean exceptionExpected, Exception e, TestResults testResults) {
        if (exceptionExpected) {
            this.pass(testResults);
        } else {
            this.error(testResults, e);
        }
    }

    @Override
    public Table getEmbeddedTable() {
        Tables tables = this.getEmbeddedTables();
        if (tables.size() != 1) {
            throw new SingleNestedTableExpected();
        }
        return (Table)tables.at(0);
    }

    @Override
    public void wrongHtml(TestResults counts, String actual) {
        this.fail(counts);
        this.addToBody(CellOnList.label("expected") + "<hr>" + actual + CellOnList.label("actual"));
    }

    private void addToBody(String msg) {
        this.fullText = this.fullText + msg;
    }

    public void setEscapedText(String text) {
        this.setText(Fixture.escape(text));
    }

    public void setMultilineEscapedText(String text) {
        this.setText(HtmlUtils.escape(text));
    }

    @Override
    public String fullText() {
        return this.fullText;
    }

    @Override
    public void setUnvisitedEscapedText(String s) {
        this.setUnvisitedText(Fixture.escape(s));
    }

    public void setUnvisitedMultilineEscapedText(String s) {
        this.setUnvisitedText(HtmlUtils.escape(s));
    }

    @Override
    public void setUnvisitedText(String s) {
        this.setText(Fixture.gray(s));
    }

    @Override
    public void passOrFailIfBlank(TestResults counts, VariableResolver resolver) {
        if (this.isBlank(resolver)) {
            this.pass(counts);
        } else {
            this.fail(counts, "", resolver);
        }
    }

    @Override
    public void passIfNotEmbedded(TestResults counts, VariableResolver resolver) {
        if (!this.hasEmbeddedTables(resolver)) {
            this.pass(counts);
        }
    }

    @Override
    public void setIsHidden() {
        this.cellIsInHiddenRow = true;
    }

    @Override
    public void setInnerTables(Tables tables) {
        this.addTables(tables);
    }

    @Override
    public int getColumnSpan() {
        Matcher matcher = COLSPAN_PATTERN.matcher(this.tagAnnotation);
        int colspan = 1;
        if (matcher.matches()) {
            colspan = Integer.parseInt(matcher.group(2));
        }
        return colspan;
    }

    @Override
    public void setColumnSpan(int colspan) {
        if (colspan < 1) {
            return;
        }
        Matcher matcher = COLSPAN_PATTERN.matcher(this.tagAnnotation);
        if (matcher.matches()) {
            this.tagAnnotation = this.tagAnnotation.replace(matcher.group(1), CellOnList.getColspanHtml(colspan));
        } else {
            this.addToTag(CellOnList.getColspanHtml(colspan));
        }
    }

    private static String getColspanHtml(int colspan) {
        return " colspan=\"" + colspan + "\"";
    }

    @Override
    public Tables getEmbeddedTables() {
        return this.fromAt(0);
    }

    @Override
    public boolean hasEmbeddedTables(VariableResolver resolver) {
        this.text(resolver);
        return !this.isEmpty();
    }

    @Override
    public String getType() {
        return "Cell";
    }

    @Override
    protected void appendBody(StringBuilder builder) {
        builder.append(this.fullText);
    }

    @Override
    public void addPrefixToFirstInnerTable(String s) {
        ((Table)this.at(0)).setLeader(Fixture.label(s) + this.getLeader());
    }
}

