/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.TableElementOnList;
import fitlibrary.table.TableFactory;
import fitlibrary.tableOnParse.CellOnParse;

public class RowOnList
extends TableElementOnList<Row, Cell>
implements Row {
    private boolean rowIsHidden = false;

    public RowOnList() {
        super("tr");
    }

    @Override
    public Cell at(int i) {
        if (i < 0 || i >= this.size()) {
            throw new MissingCellsException("at " + i);
        }
        return (Cell)super.at(i);
    }

    @Override
    public String text(int i, VariableResolver resolver) {
        return this.at(i).text(resolver);
    }

    @Override
    public Cell addCell() {
        Cell cell = TableFactory.cell("");
        ((TableElementOnList)this).add(cell);
        return cell;
    }

    @Override
    public Cell addCell(String text) {
        Cell cell = TableFactory.cell(text);
        ((TableElementOnList)this).add(cell);
        return cell;
    }

    @Override
    public Cell addCell(String text, int cols) {
        CellOnParse cell = new CellOnParse(text);
        cell.setColumnSpan(cols);
        ((TableElementOnList)this).add(cell);
        return cell;
    }

    public Cell lastCell() {
        return (Cell)this.last();
    }

    @Override
    public void pass(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    @Override
    public void fail(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    @Override
    public void error(TestResults testResults, Throwable throwable) {
        Throwable e = PlugBoard.exceptionHandling.unwrapThrowable(throwable);
        if (e instanceof FitLibraryShowException) {
            this.handleShow((FitLibraryShowException)e);
        } else {
            this.at(0).error(testResults, e);
        }
    }

    @Override
    public void missing(TestResults testResults) {
        this.at(0).expectedElementMissing(testResults);
    }

    @Override
    public void ignore(TestResults testResults) {
        for (int i = 0; i < this.size(); ++i) {
            this.at(i).ignore(testResults);
        }
    }

    @Override
    public void setIsHidden() {
        this.rowIsHidden = true;
        for (int i = 0; i < this.size(); ++i) {
            this.at(i).setIsHidden();
        }
    }

    @Override
    public void passKeywords(TestResults testResults) {
        for (int i = 0; i < this.size(); i += 2) {
            this.at(i).pass(testResults);
        }
    }

    @Override
    public Row deepCopy() {
        Row copy = TableFactory.row();
        for (int i = 0; i < this.size(); ++i) {
            copy.add((Cell)this.at(i).deepCopy());
        }
        copy.setLeader(this.getLeader());
        copy.setTrailer(this.getTrailer());
        copy.setTagLine(this.getTagLine());
        return copy;
    }

    @Override
    public String methodNameForPlain(RuntimeContextInternal runtime) {
        String name = "";
        for (int i = 0; i < this.size(); i += 2) {
            name = name + this.text(i, runtime);
            if (i + 1 >= this.size()) continue;
            name = name + "|";
        }
        return name;
    }

    @Override
    public String methodNameForCamel(RuntimeContextInternal runtime) {
        String name = "";
        for (int i = 0; i < this.size(); i += 2) {
            name = name + this.text(i, runtime) + " ";
        }
        return runtime.extendedCamel(name.trim());
    }

    @Override
    public int argumentCount() {
        return this.size() / 2;
    }

    @Override
    public int getColumnSpan() {
        int col = 0;
        for (int i = 0; i < this.size(); ++i) {
            col += this.at(i).getColumnSpan();
        }
        return col;
    }

    @Override
    public void setColumnSpan(int span) {
        if (this.isEmpty()) {
            this.addCell();
        }
        this.lastCell().setColumnSpan(span - this.getColumnSpan() + this.lastCell().getColumnSpan());
    }

    @Override
    public String getType() {
        return "Row";
    }

    @Override
    protected Row newObject() {
        return new RowOnList();
    }

    private void handleShow(FitLibraryShowException exception) {
        Cell cell = this.addCell();
        cell.setText(exception.getResult().getHtmlString());
        cell.shown();
    }
}

