/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Counts;
import fit.exception.FitParseException;
import fitlibrary.DoFixture;
import fitlibrary.parser.ParserTestCase;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoEvaluator;
import junit.framework.TestCase;

public class TestTables
extends TestCase {
    private Tables tables;
    private TestResults testResults = TestResultsFactory.testResults();
    private Counts counts = this.testResults.getCounts();
    private DoEvaluator doFixture = ParserTestCase.evaluatorWithRuntime();

    public void setUp() throws FitParseException {
        this.tables = TableFactory.tables("<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n");
    }

    public void testTables() {
        TestTables.assertEquals((int)3, (int)this.tables.size());
    }

    public void testTable0() {
        Table table = (Table)this.tables.at(0);
        TestTables.assertEquals((int)2, (int)table.size());
        TestTables.assertTrue((!table.atExists(-1) ? 1 : 0) != 0);
        TestTables.assertTrue((boolean)table.atExists(0));
        TestTables.assertTrue((boolean)table.atExists(1));
        TestTables.assertTrue((!table.atExists(2) ? 1 : 0) != 0);
        try {
            table.at(2);
            TestTables.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTable0Right() {
        Table table = (Table)this.tables.at(0);
        table.pass(this.testResults);
        TestTables.assertTrue((boolean)((Row)table.at(0)).didPass());
        TestTables.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Ignored() {
        Table table = (Table)this.tables.at(0);
        table.ignore(this.testResults);
        TestTables.assertTrue((boolean)((Cell)((Row)table.at(0)).at(0)).wasIgnored());
        TestTables.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Exception() {
        Table table = (Table)this.tables.at(0);
        table.error(this.testResults, (Throwable)new RuntimeException("Forced"));
        TestTables.assertTrue((boolean)((Cell)((Row)table.at(0)).at(0)).hadError());
        TestTables.assertTrue((boolean)((Row)table.at(0)).text(0, this.doFixture).startsWith("1java.lang.RuntimeException: Forced"));
        TestTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    public void testRow0() {
        Row row = this.getRow(0, 0);
        TestTables.assertEquals((int)1, (int)row.size());
        TestTables.assertTrue((!row.atExists(-1) ? 1 : 0) != 0);
        TestTables.assertTrue((boolean)row.atExists(0));
        TestTables.assertTrue((!row.atExists(1) ? 1 : 0) != 0);
        try {
            row.at(1);
            TestTables.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestTables.assertEquals((String)"1", (String)row.text(0, this.doFixture));
    }

    public void testRow0Right() {
        Row row = this.getRow(0, 0);
        row.pass(this.testResults);
        TestTables.assertTrue((boolean)row.didPass());
        TestTables.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Wrong() {
        Row row = this.getRow(0, 0);
        row.fail(this.testResults);
        TestTables.assertTrue((boolean)row.didFail());
        TestTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Missing() {
        Row row = this.getRow(0, 0);
        row.missing(this.testResults);
        TestTables.assertTrue((boolean)((Cell)row.at(0)).didFail());
        TestTables.assertEquals((String)"1 missing", (String)row.text(0, this.doFixture));
        TestTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Ignored() {
        Row row = this.getRow(0, 0);
        row.ignore(this.testResults);
        TestTables.assertTrue((boolean)((Cell)row.at(0)).wasIgnored());
        TestTables.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Exception() {
        Row row = this.getRow(0, 0);
        DoFixture doFixture = ParserTestCase.evaluatorWithRuntime();
        doFixture.counts = this.counts;
        row.error(this.testResults, new RuntimeException("Forced"));
        TestTables.assertTrue((boolean)((Cell)row.at(0)).hadError());
        TestTables.assertTrue((boolean)row.text(0, doFixture).startsWith("1java.lang.RuntimeException: Forced"));
        TestTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    public void testCell0Text() {
        TestTables.assertEquals((String)"1", (String)this.getCell(0, 0, 0).text(this.doFixture));
        TestTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Right() {
        Cell cell = this.getCell(0, 0, 0);
        cell.pass(this.testResults);
        TestTables.assertTrue((boolean)cell.didPass());
        TestTables.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Wrong() {
        Cell cell = this.getCell(0, 0, 0);
        cell.fail(this.testResults);
        TestTables.assertTrue((boolean)cell.didFail());
        TestTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Missing() {
        Cell cell = this.getCell(0, 0, 0);
        cell.expectedElementMissing(this.testResults);
        TestTables.assertTrue((boolean)cell.didFail());
        TestTables.assertEquals((String)"1 missing", (String)cell.text(this.doFixture));
        TestTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Ignored() {
        Cell cell = this.getCell(0, 0, 0);
        cell.ignore(this.testResults);
        TestTables.assertTrue((boolean)cell.wasIgnored());
        TestTables.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Exception() {
        Cell cell = this.getCell(0, 0, 0);
        DoFixture doFixture = ParserTestCase.evaluatorWithRuntime();
        doFixture.counts = this.counts;
        cell.error(this.testResults, new RuntimeException("Forced"));
        TestTables.assertTrue((boolean)cell.hadError());
        TestTables.assertTrue((boolean)cell.text(doFixture).startsWith("1java.lang.RuntimeException: Forced"));
        TestTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    private Cell getCell(int n, int n2, int n3) {
        return (Cell)this.getRow(n, n2).at(n3);
    }

    private Row getRow(int n, int n2) {
        return (Row)((Table)this.tables.at(n)).at(n2);
    }
}

