/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.special.PositionedTarget;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.typed.TypedObject;
import java.util.List;
import org.apache.log4j.Logger;

public class ActionSpecial
extends AbstractDoCaller {
    private static Logger logger = FitLibraryLogger.getLogger(ActionSpecial.class);
    private List<PositionedTarget> positionedTargets;
    private Evaluator evaluator;

    public ActionSpecial(Row row, Evaluator evaluator, boolean sequencing, LookupMethodTarget lookupTarget) {
        this.evaluator = evaluator;
        String[] cells = new String[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            cells[i] = row.text(i, evaluator);
        }
        this.positionedTargets = lookupTarget.findActionSpecialMethod(evaluator, cells, sequencing);
    }

    @Override
    public boolean isAmbiguous() {
        int count = 0;
        for (PositionedTarget target : this.positionedTargets) {
            if (!target.isFound()) continue;
            ++count;
        }
        return count > 1;
    }

    @Override
    public String ambiguityErrorMessage() {
        String AND = " AND ";
        String message = "";
        for (PositionedTarget target : this.positionedTargets) {
            if (!target.isFound()) continue;
            message = message + " AND " + target.ambiguityErrorMessage();
        }
        return message.substring(" AND ".length());
    }

    @Override
    public boolean isValid() {
        return this.positionedTargets.size() == 1 && this.positionedTargets.get(0).isFound();
    }

    @Override
    public boolean partiallyValid() {
        return this.positionedTargets.size() == 1 && this.positionedTargets.get(0).partiallyValid();
    }

    @Override
    public String getPartialErrorMessage() {
        return this.positionedTargets.get(0).getPartialErrorMessage();
    }

    @Override
    public TypedObject run(Row row, TestResults testResults) throws Exception {
        return this.positionedTargets.get(0).run(row, testResults, this.evaluator.getRuntimeContext());
    }
}

