/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.definedAction.ParameterBinder;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.traverse.workflow.caller.MultiDefinedActionRunnerTraverse;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;

public class MultiDefinedActionCaller
extends AbstractDoCaller {
    private final RuntimeContextInternal runtime;
    private final String methodName;
    private final ParameterBinder multiParameterSubstitution;
    private final boolean furtherRows;

    public MultiDefinedActionCaller(Row row, RuntimeContextInternal runtime) {
        this.runtime = runtime;
        this.furtherRows = runtime.hasRowsAfter(row);
        this.methodName = row.text(0, runtime.getResolver());
        this.multiParameterSubstitution = TemporaryPlugBoardForRuntime.definedActionsRepository().lookupMulti(this.methodName);
    }

    @Override
    public String ambiguityErrorMessage() {
        return "multi defined action " + this.methodName;
    }

    @Override
    public boolean isValid() {
        return this.furtherRows && this.multiParameterSubstitution != null;
    }

    @Override
    public TypedObject run(Row row, TestResults testResults) throws Exception {
        return new GenericTypedObject(new MultiDefinedActionRunnerTraverse(this.multiParameterSubstitution, this.runtime));
    }
}

