/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.definedAction;

import fitlibrary.definedAction.DefineActionsOnPage;
import fitlibrary.definedAction.DefinedActionsRepository;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.runtime.RuntimeContextInternal;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class TestDefineActionsOnPage {
    RuntimeContextContainer runtime = new RuntimeContextContainer();
    DefinedActionsRepository definedActions = TemporaryPlugBoardForRuntime.definedActionsRepository();
    protected File fitNesseDir;

    @Before
    public void setFitNesseDirectory() {
        this.fitNesseDir = new File("fitnesse");
        MatcherAssert.assertThat((String)("This test relies on files in the fitnesse directory - which cannot be found: current directory is " + new File(".").getAbsolutePath()), (Object)this.fitNesseDir.exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void actionsAreDefinedThroughFileSystem() throws Exception {
        String string = ".FitLibrary.SpecifiCations.PlainTextInsteadOfTables.DefinedActions";
        DefineActionsOnPage defineActionsOnPage = new DefineActionsOnPage(string, (RuntimeContextInternal)this.runtime){

            @Override
            protected File fitNesseDiry() {
                return TestDefineActionsOnPage.this.fitNesseDir;
            }
        };
        defineActionsOnPage.process();
        MatcherAssert.assertThat((Object)this.definedActions.lookupByCamel("addressIsAt", 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.definedActions.lookupByCamel("addressIs", 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.definedActions.lookupByClassByCamel("Person", "addressIs", 1, this.runtime), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void actionsAreDefinedThroughFileSystemExample2() throws Exception {
        String string = ".FitLibrary.SpecifiCations.DefinedActions.BasedOnClass.DefinedActions";
        DefineActionsOnPage defineActionsOnPage = new DefineActionsOnPage(string, (RuntimeContextInternal)this.runtime){

            @Override
            protected File fitNesseDiry() {
                return TestDefineActionsOnPage.this.fitNesseDir;
            }
        };
        defineActionsOnPage.process();
        MatcherAssert.assertThat((Object)this.definedActions.lookupByCamel("nameIs", 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.definedActions.lookupByClassByCamel("Person", "nameIs", 1, this.runtime), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

