/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fit.Parse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class ParseUtility {
    public static final String ASCII_ENCODING = "ASCII";
    private static final String START_BODY = "<body>";
    public static final String END_BODY = "</body>";

    public static String toString(Parse parse) {
        if (parse == null) {
            return "<null>";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        parse.print(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static void printParse(Parse tables, String title) {
        System.out.println("---------Tables for " + title + ":----------");
        if (tables != null) {
            PrintWriter printWriter = new PrintWriter(System.out);
            tables.print(printWriter);
            printWriter.flush();
        }
        System.out.println("-------------------");
    }

    public static void addRowToTable(Parse table, String[] cells) {
        Parse root;
        if (cells.length == 0) {
            throw new RuntimeException("Can't have an empty row.");
        }
        Parse here = root = new Parse(null, null, null, null);
        for (int i = 0; i < cells.length; ++i) {
            here = here.more = new Parse("td", cells[i], null, null);
        }
        table.parts.last().more = new Parse("tr", "", root.more, null);
    }

    protected void addRowToTable(Parse table, String s) {
        ParseUtility.addRowToTable(table, new String[]{s});
    }

    public static void appendToSetUp(Parse front, Parse back) {
        if (back == null) {
            return;
        }
        ParseUtility.changeHeader(front, ParseUtility.removeHeader(back));
        ParseUtility.fixTrailers(front, back);
        front.last().more = back;
    }

    public static void append(Parse front, Parse back) {
        if (back == null) {
            return;
        }
        ParseUtility.removeHeader(back);
        ParseUtility.fixTrailers(front, back);
        front.last().more = back;
    }

    public static void fixTrailers(Parse front, Parse back) {
        String frontTrailer;
        Parse frontLast = front.last();
        String extra = frontTrailer = frontLast.trailer;
        int index = frontTrailer.indexOf(END_BODY);
        if (index >= 0) {
            extra = frontTrailer.substring(0, index);
        }
        if (!extra.equals("")) {
            back.leader = back.leader.equals("\n<br>") ? extra + back.leader : extra + "<br>" + back.leader;
        }
        frontLast.trailer = "";
    }

    public static String removeHeader(Parse tables) {
        int index = tables.leader.indexOf(START_BODY);
        if (index < 0) {
            return "";
        }
        String result = tables.leader.substring(0, index += START_BODY.length());
        tables.leader = tables.leader.substring(index);
        return result;
    }

    public static void changeHeader(Parse tables, String tablesHeader) {
        int index = tables.leader.indexOf(START_BODY);
        tables.leader = index < 0 ? tablesHeader + tables.leader : tablesHeader + tables.leader.substring(index + START_BODY.length());
    }

    public static void completeTrailer(Parse tables) {
        Parse last = tables.last();
        int index = last.trailer.indexOf(END_BODY);
        if (index < 0) {
            last.trailer = last.trailer + "\n</body></html>\n";
        }
    }

    public static Parse copyParse(Parse tables) {
        if (tables == null) {
            return null;
        }
        Parse parse = new Parse("", tables.body, ParseUtility.copyParse(tables.parts), ParseUtility.copyParse(tables.more));
        parse.tag = tables.tag;
        parse.end = tables.end;
        parse.leader = tables.leader;
        parse.trailer = tables.trailer;
        return parse;
    }

    public static void writeParse(File report, Parse parse) throws UnsupportedEncodingException, FileNotFoundException {
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(report), ASCII_ENCODING));
        parse.print(output);
        output.close();
    }

    public static String tabulize(String originalHtml) {
        int start;
        String html = originalHtml;
        while ((start = html.indexOf("<br/>- ")) >= 0) {
            int end = html.indexOf("<br/>", start + 5);
            if (end < 0) {
                end = html.length();
            }
            String table = "\n<table border=\"1\" cellspacing=\"0\"><tr><td><i>run plain</i></td><td>" + html.substring(start + 7, end) + "</td></tr>\n</table>\n";
            html = html.substring(0, start + 5) + table + html.substring(end);
        }
        return html;
    }

    public static String translate(String originalHtml) {
        String html = originalHtml;
        while (true) {
            int end;
            int start = html.indexOf("<br/>* ");
            int offset = 7;
            if (start < 0) {
                start = html.indexOf("\n* ");
                offset = 3;
                end = html.indexOf("\n", start + offset);
            } else {
                end = html.indexOf("<br/>", start + offset);
            }
            if (start < 0) break;
            int tagEnd = end < 0 ? (end = html.length()) : end + offset - 2;
            String line = ParseUtility.findRows(html.substring(start + offset, end));
            String table = "\n<table><tr>" + line + "</tr></table>\n";
            html = html.substring(0, start) + table + html.substring(tagEnd);
        }
        return html;
    }

    private static String findRows(String originalLine) {
        String line = originalLine;
        String table = "";
        while (!"".equals(line)) {
            int endCell = ParseUtility.end(line);
            table = table + "<td>" + line.substring(0, endCell).trim() + "</td>";
            if (!(line = line.substring(endCell)).startsWith(" ")) continue;
            line = line.substring(1);
        }
        return table;
    }

    private static int start(String line, String tag) {
        int it = line.indexOf(tag);
        if (it < 0) {
            return line.length();
        }
        return it;
    }

    private static int end(String line) {
        if (line.startsWith("<i>")) {
            return ParseUtility.end(line, "</i>");
        }
        if (line.startsWith("<b>")) {
            return ParseUtility.end(line, "</b>");
        }
        return Math.min(ParseUtility.start(line, "<i>"), ParseUtility.start(line, "<b>"));
    }

    private static int end(String line, String endTag) {
        int end = line.indexOf(endTag);
        end = end < 0 ? line.length() : (end += 4);
        return end;
    }
}

