/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.log.FixturingLogger;
import fitlibrary.server.AbstractHttpRequestHandler;
import fitlibrary.ws.soap.Soap;
import java.io.IOException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class WebServiceHandler
extends AbstractHttpRequestHandler {
    static Logger logger2 = FixturingLogger.getLogger(WebServiceHandler.class);

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!method.equals("POST")) {
            throw new MethodNotSupportedException(String.valueOf(method) + " method not supported: only POST supported");
        }
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            this.error(response, 403, "No text/xml provided");
            return;
        }
        HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
        String contentType = entity.getContentType().getValue();
        logger2.trace((Object)("Content type: " + contentType));
        switch (Soap.decodedType(contentType)) {
            case PLAIN: {
                this.callPlainPost(response, entity);
                break;
            }
            case XML: 
            case SOAP11: {
                this.callSoap(response, entity, "<?xml version='1.0' encoding='utf-8'?>\n<soap:Envelope xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/'>\n<soap:Body>\n", "</soap:Body>\n</soap:Envelope>\n");
                break;
            }
            case SOAP12: {
                this.callSoap(response, entity, "<?xml version='1.0' encoding='utf-8'?>\n<soap12:Envelope xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:soap12='http://www.w3.org/2003/05/soap-envelope'>\n<soap12:Body>\n", "</soap12:Body>\n</soap12:Envelope>\n");
                break;
            }
            case INVALID: {
                this.error(response, 403, "Request format is invalid: " + contentType);
            }
        }
    }

    private void callSoap(HttpResponse response, HttpEntity entity, String header, String trailer) throws IOException {
        String entityContent = EntityUtils.toString((HttpEntity)entity);
        logger2.trace((Object)("Incoming entity content: " + entityContent));
        String countTag = "<Count>";
        int start = entityContent.indexOf(countTag);
        if (start < 0) {
            this.error(response, 403, "Missing parameter: Count");
            return;
        }
        int end = entityContent.indexOf("</Count>", start);
        if (end < 0) {
            this.error(response, 403, "Missing parameter: Count");
            return;
        }
        String countString = entityContent.substring(start + countTag.length(), end);
        try {
            int count = Integer.parseInt(countString);
            EntityTemplate body = this.makeBody(String.valueOf(header) + "<CountResult>" + (count + 1) + "</CountResult>\n" + trailer, "text/xml; charset=UTF-8");
            response.setEntity((HttpEntity)body);
            response.setStatusCode(200);
        }
        catch (NumberFormatException e) {
            this.error(response, 403, "Bad number format: " + countString);
        }
    }

    private void callPlainPost(HttpResponse response, HttpEntity entity) throws IOException {
        String entityContent = EntityUtils.toString((HttpEntity)entity);
        logger2.trace((Object)("Incoming entity content: " + entityContent));
        String[] split = entityContent.split("=");
        if (split.length != 2) {
            this.error(response, 403, "Missing parameter: Count");
            return;
        }
        try {
            int count = Integer.parseInt(split[1]);
            EntityTemplate body = this.makeBody("<?xml version='1.0' encoding='utf-8'?>\n<string xmlns='http://tempuri.org'>" + (count + 1) + "</string>\n", "text/xml; charset=UTF-8");
            response.setEntity((HttpEntity)body);
            response.setStatusCode(200);
        }
        catch (NumberFormatException e) {
            this.error(response, 403, "Bad number format: " + split[1]);
        }
    }
}

