/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider;

import fit.Parse;
import fitlibrary.annotation.CompoundAction;
import fitlibrary.annotation.NullaryAction;
import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.FixturingLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.spider.Finder;
import fitlibrary.spider.LookupFixture;
import fitlibrary.spider.MultiLineMatchFixture;
import fitlibrary.spider.SpiderElementFixture;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.TableFixture;
import fitlibrary.spider.component.Alert;
import fitlibrary.spider.component.Frame;
import fitlibrary.spider.component.Page;
import fitlibrary.spider.component.SpiderWindow;
import fitlibrary.spider.component.TextInPage;
import fitlibrary.spider.driver.DriverVariation;
import fitlibrary.spider.element.ElementWithAttributes;
import fitlibrary.spider.element.LinkAndFormElement;
import fitlibrary.spider.element.SelectElement;
import fitlibrary.spider.element.SpiderWebElement;
import fitlibrary.spider.element.TextElement;
import fitlibrary.spider.polling.Poll;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.polling.PollForNoException;
import fitlibrary.spider.polling.PollForWithError;
import fitlibrary.spider.utility.HtmlTextUtility;
import fitlibrary.spider.utility.WebElementSelector;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.DoTraverse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@ShowSelectedActions
public abstract class AbstractSpiderFixture
extends DoTraverse {
    private static Logger logger = FixturingLogger.getLogger(SpiderFixture.class);
    private static final String CHECKING_TIMEOUT = "checking";
    protected Finder finder;
    private SpiderFixture spiderFixture;
    private boolean checking = true;
    protected DriverVariation driverVariation = new DriverVariation(this);
    private TextElement textElement = new TextElement(this);
    private ElementWithAttributes elementWithAttributes = new ElementWithAttributes(this);
    private SelectElement selectElement = new SelectElement(this);
    private LinkAndFormElement linkAndFormElement = new LinkAndFormElement(this);

    public SpiderFixture spiderFixture() {
        return this.spiderFixture;
    }

    @SimpleAction(wiki="|''<i>poll url timeout</i>''|timeout in milliseconds|", tooltip="Specify how long to wait for a page to load from a URL.")
    public void pollUrlTimeout(int timeout) {
        this.putTimeout("pollUrl", timeout);
    }

    public Finder getFinder() {
        return this.finder;
    }

    public void setElementFinder(Finder finder) {
        this.finder = finder;
    }

    public void setSpiderFixture(SpiderFixture spiderFixture) {
        this.spiderFixture = spiderFixture;
    }

    public WebDriver webDriver() {
        return this.spiderFixture.webDriver();
    }

    @SimpleAction(wiki="|''<i>set checking</i>''|true or false|", tooltip="If true, changes to web elements are checked after they have been made.")
    public void setChecking(boolean checking) {
        this.checking = checking;
    }

    @SimpleAction(wiki="|''<i>checking timeout</i>''|timeout in milliseconds|", tooltip="If checking that a change has been made to a web element, how long to wait for a change to be visible.")
    public void checkingTimeout(int timeout) {
        this.putTimeout(CHECKING_TIMEOUT, timeout);
    }

    public void shutDown() throws IOException {
        this.spiderFixture.tearDownDriver();
    }

    @NullaryAction(tooltip="If a failure has occurred, create a screen dump (if supported) and stop.")
    public void shutDownWithScreenDumpOnFailure() {
        if (this.getRuntimeContext().getTestResults().problems()) {
            this.screenDump();
        }
        this.spiderFixture.tearDownDriver();
    }

    @SimpleAction(wiki="|''<i>execute JavaScript</i>''|JavaScript code|", tooltip="Execute the JavaScript code in the browser and return the result.")
    public Object executeJavaScript(String s) {
        JavascriptExecutor js = (JavascriptExecutor)this.webDriver();
        return js.executeScript(s, new Object[0]);
    }

    public boolean executeJavaScriptExpecting(String s, boolean expected) {
        try {
            JavascriptExecutor js = (JavascriptExecutor)this.webDriver();
            js.executeScript(s, new Object[0]);
            return expected;
        }
        catch (Exception e) {
            return !expected;
        }
    }

    @SimpleAction(wiki="|''<i>execute JavaScript</i>''|JavaScript code|''<i>with</>''|web element|", tooltip="Execute the JavaScript code in the browser with the argument and return the result.")
    public Object executeJavaScriptWith(String script, Object param) {
        JavascriptExecutor js = (JavascriptExecutor)this.webDriver();
        return js.executeScript(script, new Object[]{param});
    }

    @SimpleAction(wiki="|''<i>execute JavaScript</i>''|JavaScript code|''<i>with element</>''|xpath, id or other locator|", tooltip="Find a element on the page using the locator specified and then execute the JavaScript code in the browser using the found element as an the argument and return the result.")
    public Object executeJavaScriptWithElement(String script, String locator) {
        WebElement element = this.findElement(locator);
        return this.executeJavaScriptWith(script, element);
    }

    @SimpleAction(wiki="|''<i>get url</i>''|url|", tooltip="Retrieve the page at the url.")
    public boolean getUrl(String url) throws Exception {
        return this.page().getUrl(url);
    }

    @NullaryAction(tooltip="Go back to the previous page in the browser, if any.")
    public boolean back() {
        return this.page().back();
    }

    @NullaryAction(tooltip="Go forward to the next page in the browser, if any.")
    public boolean forward() {
        return this.page().forward();
    }

    @NullaryAction(tooltip="Returns the title of the current page.")
    public String title() {
        return this.page().getTitle();
    }

    public String getTitle() {
        return this.page().getTitle();
    }

    @NullaryAction(tooltip="Returns the url of the current page.")
    public String url() {
        return this.page().getUrl();
    }

    public String getUrl() {
        return this.page().getUrl();
    }

    public void pollUrl(Row row, TestResults testResults) throws Exception {
        this.page().pollUrl(row, testResults);
    }

    @NullaryAction(tooltip="Have the browser refresh the current page.")
    public void refreshPage() {
        this.page().refresh();
    }

    @SimpleAction(wiki="|''<i>show error diagnostics at</i>''|xpath|''<i>when page contains</i>''|pattern|", tooltip="When a website responds with an error message at xpath that's not expected, it's handy if diagnostic information is automatically provided about this in the storytest report.")
    public void showErrorDiagnosticsAtWhenPageContains(String xpath, String pattern) {
        this.page().showErrorDiagnosticsAtWhenPageContains(xpath, pattern);
    }

    @NullaryAction(tooltip="Check if any errors have occurred .")
    public void checkForError() {
        this.page().checkForError();
    }

    private Page page() {
        return this.spiderFixture.getPage();
    }

    @NullaryAction(tooltip="The internal name of the current window.")
    public String currentWindow() {
        return this.window().currentWindow();
    }

    @NullaryAction(tooltip="The internal name of open browser window.")
    public String windows() {
        return this.window().windows();
    }

    @NullaryAction(tooltip="After selecting another window, select the initial window again.")
    public boolean selectInitialWindow() {
        return this.window().selectInitialWindow();
    }

    @SimpleAction(wiki="|''<i>select window</i>''|name|", tooltip="Select a window by name.")
    public boolean selectWindow(String name) {
        return this.window().selectWindow(name);
    }

    public boolean selectWindowWithAs(String xpath, String value) {
        return this.window().selectWindowWithAs(xpath, value);
    }

    public boolean selectWindowWithContains(String xpath, String value) {
        return this.window().selectWindowWithContains(xpath, value);
    }

    @NullaryAction(tooltip="Selecting the other window, of two.")
    public boolean selectOtherWindow() {
        return this.window().selectOtherWindow();
    }

    @NullaryAction(tooltip="Close the current window.")
    public boolean close() {
        return this.window().close();
    }

    private SpiderWindow window() {
        return this.spiderFixture.getWindow();
    }

    @SimpleAction(wiki="|''<i>select frame</i>''|index of frame|", tooltip="Select the nth frame.")
    public boolean frame(int frameNo) {
        return this.frame().frame(frameNo);
    }

    @SimpleAction(wiki="|''<i>select frame by name</i>''|name of frame|", tooltip="Select a frame by name.")
    public boolean frameByName(String frameName) {
        return this.frame().frameByName(frameName);
    }

    @NullaryAction(tooltip="Select the default frame.")
    public boolean defaultFrame() {
        return this.frame().defaultFrame();
    }

    private Frame frame() {
        return this.spiderFixture.getFrame();
    }

    public boolean pageContainsText(String text) {
        return this.textInPage().pageContainsText(text);
    }

    public boolean pageContainsTextIgnoreHtmlBreakingTokens(String text) {
        return this.textInPage().pageContainsTextIgnoreHtmlBreakingTokens(text);
    }

    public boolean pageContainsRegularExpression(String regEx) {
        return this.textInPage().pageContainsRegularExpression(regEx);
    }

    public String pageSubstringFromTo(String prior, String subsequent) {
        return this.textInPage().pageSubstringFromTo(prior, subsequent);
    }

    @NullaryAction(tooltip="Returns the html of the page.")
    public String pageSource() {
        return this.textInPage().pageSource();
    }

    @NullaryAction(tooltip="Returns the html of the page after cleaning it up.\nMultiple spaces are turned into a single space.\nBreaks and non-breaking spaces are turned into spaces.")
    public String pageSourceCleaned() {
        return this.textInPage().pageSourceCleaned();
    }

    private TextInPage textInPage() {
        return this.spiderFixture.getTextInPage();
    }

    @SimpleAction(wiki="|''<i>text of</i>''|xpath, id or other locator|", tooltip="Return the text of the given web element.")
    public String textOf(String locator) {
        return this.textElement.textOf(locator);
    }

    @SimpleAction(wiki="|''<i>plain text of</i>''|xpath, id or other locator|", tooltip="Return the plain text of the given web element. Tags are removed.")
    public String plainTextOf(String locator) {
        return this.textElement.plainTextOf(locator);
    }

    @SimpleAction(wiki="|''<i>text of</i>''|xpath, id or other locator|''<i>matches lines</i>''|", tooltip="Checks that the lines in the given text element match each of the following rows in the table.")
    public MultiLineMatchFixture textOfMatchesLines(String locator) {
        return this.textElement.textOfMatchesLines(locator);
    }

    public boolean optionallyWithSetText(String locator, String s) {
        return this.textElement.optionallyWithSetText(locator, s);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>set text</i>''|text|", tooltip="Change the text of the given web element.")
    public boolean withSetText(String locator, String s) {
        return this.textElement.withSetText(locator, s);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>add text</i>''|text|", tooltip="Add to the text of the given web element.")
    public boolean withAddText(String locator, String s) {
        return this.textElement.withAddText(locator, s);
    }

    @SimpleAction(wiki="|''<i>inner html of</i>''|xpath, id or other locator|", tooltip="Return the html that's enclosed by the given web element.")
    public String innerHtmlOf(String locator) {
        return this.textElement.innerHtmlOf(locator);
    }

    @SimpleAction(wiki="|''<i>text of element only</i>''|xpath, id or other locator|", tooltip="Return only the text that is in the identified element, no text of any inner html will be returned\n.This should return the text that an xpath ''//div/text()'' would return as opposed to ''//div/.'' that the browser will normally render (and is returned by '''text of'''.")
    public String textOfElementOnly(String locator) {
        return this.textElement.textOfElementOnly(locator);
    }

    @SimpleAction(wiki="|''<i>element exists</i>''|xpath, id or other locator|", tooltip="Returns true if the given web element exists on the page.")
    public boolean elementExists(String locator) {
        return this.elementWithAttributes.elementExists(locator);
    }

    @SimpleAction(wiki="|''<i>element does not exist</i>''|xpath, id or other locator|", tooltip="Returns true if the given web element does not exist on the page.")
    public boolean elementDoesNotExist(String locator) {
        return this.elementWithAttributes.elementDoesNotExist(locator);
    }

    @SimpleAction(wiki="|''<i>element value</i>''|xpath, id or other locator|", tooltip="Returns the value of the given web element.")
    public String elementValue(String locator) {
        return this.elementWithAttributes.elementValue(locator);
    }

    @SimpleAction(wiki="|''<i>attribute</i>''|attribute name|''<i>of</i>''|xpath, id or other locator|", tooltip="Returns the value of the given attribute in the given web element.")
    public String attributeOf(String attributeName, String locator) {
        return this.elementWithAttributes.attributeOf(attributeName, locator);
    }

    @SimpleAction(wiki="|''<i>attribute of</i>''|xpath, id or other locator|''<i>exists</i>''|", tooltip="Returns true if the given attribute exists in the given web element.")
    public boolean attributeOfExists(String attributeName, String locator) {
        return this.elementWithAttributes.attributeOfExists(attributeName, locator);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>css property of</i>''|css property name|", tooltip="Returns the value of the given css property of the given web element.")
    public String withCssPropertyOf(String locator, String property) {
        return this.elementWithAttributes.withCssPropertyOf(locator, property);
    }

    @SimpleAction(wiki="|''<i>count of</i>''|xpath, id or other locator|", tooltip="Returns the count of elements that match the given locator.")
    public int countOf(String locator) {
        return this.elementWithAttributes.countOf(locator);
    }

    @SimpleAction(wiki="|''<i>attribute</i>''|attribute|''<i>of children of type</i>''|child tag|''<i>of</i>''|xpath, id or other locator|", tooltip="Returns a list of information about the attributes of each of the children with the given tag contained by the given web element.\n")
    public List<String> attributeOfChildrenOfTypeOf(String attribute, String childType, String locator) {
        return this.elementWithAttributes.attributeOfChildrenOfTypeOf(attribute, childType, locator);
    }

    @CompoundAction(wiki="|''<i>find element from</i>''|xpath, id or other locator|''<i>with tag</i>''|tag|''<i>where</i>''|", tooltip="From the given locator, find child elements with the given tag.\nActions in the rest of the table can select further.")
    public WebElementSelector findElementFromWithTagWhere(String locator, String tag) {
        return this.elementWithAttributes.findElementFromWithTagWhere(locator, tag);
    }

    @SimpleAction(wiki="|''<i>element is visible</i>''|xpath, id or other locator|", tooltip="Returns true if the given web element is displayed (visible to the user).")
    public boolean elementVisible(String locator) {
        return this.findElement(locator).isDisplayed();
    }

    @SimpleAction(wiki="|''<i>element invisible</i>''|xpath, id or other locator|", tooltip="Returns true if the given web element is not displayed (invisible to the user).")
    public boolean elementInvisible(String locator) {
        return !this.elementVisible(locator);
    }

    @SimpleAction(wiki="|''<i>checkbox</i>''|xpath, id or other locator|", tooltip="Returns true if the given checkbox is currently selected.")
    public boolean checkbox(String locator) {
        return this.findElement(locator).isSelected();
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>select</i>''|true or false|", tooltip="Either select (true) or unselect (false) the given checkbox.")
    public boolean withSelect(String locator, final boolean select) {
        final WebElement element = this.findElement(locator);
        if (element.isSelected()) {
            if (!select) {
                element.click();
            }
        } else if (select) {
            element.click();
        }
        this.ensureBecomes(new PollForWithError(){

            @Override
            public boolean matches() {
                return element.isSelected() == select;
            }

            @Override
            public String error() {
                return "Not selected correctly";
            }
        });
        return true;
    }

    @SimpleAction(wiki="|''<i>option of</i>''|xpath, id or other locator|", tooltip="Returns the name of the currently-selected option in the given select.")
    public String optionOf(String locator) {
        return this.selectElement.optionOf(locator);
    }

    protected List<WebElement> childrenOf(String locator, String tag) {
        return this.findElement(locator).findElements(By.tagName((String)tag));
    }

    @SimpleAction(wiki="|''<i>option list of</i>''|xpath, id or other locator|", tooltip="Returns a list of the names of the currently-selected options in the given multi-select.\nThis can be checked in the subsequent rows of the table.")
    public List<String> optionListOf(String locator) {
        return this.selectElement.optionListOf(locator);
    }

    public boolean optionallyWithSelectOption(String locator, String option) {
        return this.selectElement.optionallyWithSelectOption(locator, option);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>select option</i>''|option|", tooltip="Changes the option in the given select.")
    public boolean withSelectOption(String locator, String option) {
        return this.selectElement.withSelectOption(locator, option);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>select option at</i>''|index|", tooltip="Changes the option to the nth one, in the given select.")
    public boolean withSelectOptionAt(String locator, int index) {
        return this.selectElement.withSelectOptionAt(locator, index);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>select text</i>''|text of option|", tooltip="Changes the option to the one with the given text, in the given select.")
    public boolean withSelectText(String locator, String text) {
        return this.selectElement.withSelectText(locator, text);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>add selection</i>''|option|", tooltip="Adds the given option to the given multi-select.")
    public boolean withAddSelection(String locator, String option) {
        return this.selectElement.withAddSelection(locator, option);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>remove selection</i>''|option|", tooltip="Removes the given option from the given multi-select.")
    public boolean withRemoveSelection(String locator, String option) {
        return this.selectElement.withRemoveSelection(locator, option);
    }

    @SimpleAction(wiki="|''<i>option values</i>''|xpath, id or other locator|", tooltip="Returns a list of the values of the currently-selected options in the given multi-select.")
    public List<String> optionValues(String locator) {
        return this.selectElement.optionValues(locator);
    }

    @SimpleAction(wiki="|''<i>options</i>''|xpath, id or other locator|", tooltip="Returns a list of the elements for the options in the select or multi-select.\nThis list can be checked in the subsequent rows of the table.")
    public List<SpiderWebElement> options(String locator) {
        return this.selectElement.options(locator);
    }

    @SimpleAction(wiki="|''<i>table values</i>''|xpath, id or other locator|", tooltip="Returns the elements of the given table as a TableFixture, which can be used to check the text of each of those elements.")
    public TableFixture tableValues(String locator) {
        ArrayList<List<String>> stringTable = new ArrayList<List<String>>();
        for (WebElement option : this.childrenOf(locator, "tr")) {
            ArrayList<String> stringRow = new ArrayList<String>();
            stringTable.add(stringRow);
            for (WebElement element : option.findElements(By.tagName((String)"td"))) {
                stringRow.add(element.getText());
            }
        }
        return new TableFixture(stringTable);
    }

    @SimpleAction(wiki="|''<i>click</i>''|xpath, id or other locator|", tooltip="Click on the given element, such as a link or button.")
    public boolean click(String locator) {
        return this.linkAndFormElement.click(locator);
    }

    @SimpleAction(wiki="|''<i>click and select resulting window</i>''|xpath, id or other locator|", tooltip="Click on the given element and select the popup window that results.")
    public boolean clickAndSelectResultingWindow(String locator) {
        return this.linkAndFormElement.clickAndSelectResultingWindow(locator);
    }

    @SimpleAction(wiki="|''<i>click on named link</i>''|link name|", tooltip="Click on the first link with the given name.")
    public boolean clickOnNamedLink(String linkName) {
        return this.linkAndFormElement.clickOnNamedLink(linkName);
    }

    @SimpleAction(wiki="|''<i>click on partially named link</i>''|partial link name|", tooltip="Click on the first link that contains the given name.")
    public boolean clickOnPartiallyNamedLink(String linkName) {
        return this.linkAndFormElement.clickOnPartiallyNamedLink(linkName);
    }

    @SimpleAction(wiki="|''<i>submit</i>''|xpath, id or other locator|", tooltip="Submit the given form.")
    public void submit(String locator) {
        this.linkAndFormElement.submit(locator);
    }

    @SimpleAction(wiki="|''<i>add cookie</i>''|name|''<i>with value</i>''|value|", tooltip="Add the cookie.")
    public boolean addCookieWithValue(String name, String value) {
        Calendar farInFuture = Calendar.getInstance();
        farInFuture.set(1, 3000);
        this.webDriver().manage().addCookie(new Cookie.Builder(name, value).path("").isSecure(false).expiresOn(farInFuture.getTime()).build());
        return true;
    }

    @SimpleAction(wiki="|''<i>delete cookie</i>''|name|", tooltip="Delete the cookie with the given name.")
    public boolean deleteCookie(String name) {
        this.webDriver().manage().deleteCookieNamed(name);
        return true;
    }

    @NullaryAction(tooltip="Delete all of the cookies.")
    public boolean deleteAllCookies() {
        this.webDriver().manage().deleteAllCookies();
        return true;
    }

    @NullaryAction(tooltip="Return a set of cookies, which can be checked in the rest of the table.")
    public Set<Cookie> cookies() {
        return this.webDriver().manage().getCookies();
    }

    @NullaryAction(tooltip="Dismiss a pop-up javascript alert, if the alert is a confirm alert will dismiss without accepting.")
    public boolean dismissAlert() {
        return this.alert().dismissAlert();
    }

    @NullaryAction(tooltip="Dismiss a pop-up javascript alert, if the alert is a confirm alert the alert will be accepted.")
    public boolean acceptAlert() {
        return this.alert().acceptAlert();
    }

    @NullaryAction(tooltip="Get the text message from within a pop-up javascript alert.")
    public String getAlertMessage() {
        return this.alert().getAlertMessage();
    }

    @NullaryAction(tooltip="Enter text into a prompt style javascript pop-up alert.")
    public boolean enterAlertText(String text) {
        return this.alert().enterAlertText(text);
    }

    private Alert alert() {
        return this.spiderFixture.getAlert();
    }

    @NullaryAction(tooltip="Take a screen dump and insert the result in the report, if the browser supports it.")
    public void screenDump() {
        this.driverVariation.screenDump();
    }

    @SimpleAction(wiki="|''<i>screen dump</i>''|file name|", tooltip="Take a screen dump and write it to the given file.")
    public void screenDump(String fileName) {
        this.driverVariation.screenDump(fileName);
    }

    @SimpleAction(wiki="|''<i>screen dump directory</i>''|folder name|", tooltip="Specify the folder where screen dumps are to be placed.")
    public void screenDumpDirectory(String diryName) {
        this.driverVariation.setScreenDumpDirectory(diryName);
    }

    @SimpleAction(wiki="|''<i>with</i>''|xpath, id or other locator|''<i>do</i>''|", tooltip="Select the given web element.\nActions in subsequent rows of the table apply within the context of that element, using any of the Spider actions.")
    public SpiderElementFixture withDo(String locator) {
        return this.spiderElementFixture(this.findElement(locator));
    }

    @SimpleAction(wiki="|''<i>with table</i>''|xpath, id or other locator|''<i>select row with</i>''|locator for row within the table|", tooltip="Select the given row within the table.\nActions in subsequent rows of the table apply within the context of that element, using any of the Spider actions.")
    public SpiderElementFixture withTableSelectRowWith(String tableLocator, String givenRowLocator) {
        String rowLocator = givenRowLocator;
        if (rowLocator.startsWith("//")) {
            rowLocator = "." + rowLocator;
        }
        try {
            WebElement tableWebElement = this.findElement(tableLocator);
            for (WebElement rowElement : tableWebElement.findElements(By.tagName((String)"tr"))) {
                for (WebElement cellElement : rowElement.findElements(By.tagName((String)"td"))) {
                    try {
                        WebElement webElement = cellElement.findElement(By.xpath((String)rowLocator));
                        if (webElement == null) continue;
                        return this.spiderElementFixture(rowElement);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (NoSuchElementException ex) {
            throw new FitLibraryException("Unable to find row with path " + rowLocator);
        }
        throw new FitLibraryException("No matching row");
    }

    protected SpiderElementFixture spiderElementFixture(WebElement rowElement) {
        return new SpiderElementFixture(rowElement, this.spiderFixture);
    }

    @NullaryAction(tooltip="Returns a LookupFixture, that can be used to look up values in the following rows of the table.")
    public LookupFixture lookup() {
        return new LookupFixture();
    }

    public WebElement findElement(final String locator) {
        try {
            return this.ensureNoException(new PollForNoException<WebElement>(){

                @Override
                public WebElement act() {
                    return AbstractSpiderFixture.this.finder.findElement(locator);
                }
            });
        }
        catch (NoSuchElementException ex) {
            throw this.problem("No such element", locator);
        }
        catch (Exception ex) {
            throw this.problem("Unknown xpath (" + ex.getMessage() + ")", locator);
        }
    }

    public FitLibraryException problem(String problemDescription, String details) {
        return new FitLibraryException(String.valueOf(problemDescription) + ": '" + details + "'" + this.atShortUrl());
    }

    private String atShortUrl() {
        String url = "";
        try {
            url = this.webDriver().getCurrentUrl();
            int pos = url.indexOf(";");
            if (pos >= 0) {
                return " at " + url.substring(0, pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return " at " + url;
    }

    public String collectText(WebElement element) {
        return this.collectText(element, true);
    }

    private String collectText(WebElement element, boolean trim) {
        String value = element.getText();
        if (value == null || "".equals(value.trim())) {
            value = element.getAttribute("value");
        }
        if (value == null) {
            value = "";
        }
        if (trim) {
            value = HtmlTextUtility.crLfRemoved(HtmlTextUtility.spacesToSingleSpace(HtmlTextUtility.nonBreakingSpaceToSpace(HtmlTextUtility.tabToSpace(HtmlTextUtility.brToSpace(value))))).trim();
        }
        return Parse.unescape((String)value);
    }

    public void ensureBecomes(PollForWithError poll) {
        this.ensureWithError(poll, this.getTimeout("becomes"));
    }

    public void ensureWithError(PollForWithError poll, int timeout) {
        if (this.checking) {
            new Poll(timeout).ensureWithError(poll);
        }
    }

    public boolean ensureMatches(PollForMatches poll) {
        return new Poll(this.getTimeout(CHECKING_TIMEOUT)).ensureMatches(poll);
    }

    public boolean ensureMatchesNoException(PollForMatches poll) {
        return new Poll(this.getTimeout(CHECKING_TIMEOUT)).ensureMatchesNoException(poll);
    }

    public <T> T ensureNoException(PollForNoException<T> poll) throws Exception {
        return new Poll(this.getTimeout(CHECKING_TIMEOUT)).ensureNoException(poll);
    }
}

