/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import java.util.regex.Pattern;

public class LookupFixture
extends Traverse {
    private String[] header;
    private boolean[] matchOn;

    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Row headerRow = (Row)table.at(1);
        int headerRowSize = headerRow.size();
        this.analyseHeaders(headerRow, headerRowSize);
        if (!this.matchInTable(table, headerRowSize)) {
            ((Cell)((Row)table.at(0)).at(0)).error(testResults, "No match");
        }
        return null;
    }

    private boolean analyseHeaders(Row headerRow, int headerRowSize) {
        this.header = new String[headerRowSize];
        this.matchOn = new boolean[headerRowSize];
        boolean atLeastOneSetVariableHeaderFound = false;
        int i = 0;
        while (i < headerRowSize) {
            this.matchOn[i] = true;
            this.header[i] = headerRow.text(i, (VariableResolver)this);
            if (this.header[i].endsWith("?")) {
                this.header[i] = this.header[i].substring(0, this.header[i].length() - 1);
                this.matchOn[i] = false;
                atLeastOneSetVariableHeaderFound = true;
            }
            ++i;
        }
        if (atLeastOneSetVariableHeaderFound) {
            return true;
        }
        throw new FitLibraryException("No header with '?'");
    }

    private boolean matchInTable(Table table, int headerRowSize) {
        int rowNo = 2;
        while (rowNo < table.size()) {
            Row row = (Row)table.at(rowNo);
            if (row.size() != headerRowSize) {
                throw new FitLibraryException("Row needs to be " + headerRowSize + " cells wide");
            }
            if (this.matchRow(row)) {
                this.updateVariables(row);
                return true;
            }
            ++rowNo;
        }
        return false;
    }

    private boolean matchRow(Row row) {
        int cell = 0;
        while (cell < row.size()) {
            String regEx = row.text(cell, (VariableResolver)this);
            if (this.matchOn[cell] && !Pattern.compile(".*" + regEx + ".*", 32).matcher(this.header[cell]).matches()) {
                return false;
            }
            ++cell;
        }
        return true;
    }

    private void updateVariables(Row row) {
        int cell = 0;
        while (cell < row.size()) {
            if (!this.matchOn[cell]) {
                this.getDynamicVariables().put(this.header[cell], (Object)row.text(cell, (VariableResolver)this));
            }
            ++cell;
        }
    }
}

