/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.QueryTable;
import fitnesse.slimTables.Table;

public class OrderedQueryTable
extends QueryTable {
    private int lastMatchedRow = -1;

    public OrderedQueryTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    @Override
    protected void scanRowForMatch(int tableRow) throws Exception {
        int matchedRow = this.queryResults.findBestMatch(tableRow);
        if (matchedRow == -1) {
            this.replaceAllvariablesInRow(tableRow);
            this.failMessage(0, tableRow, "missing");
        } else {
            int columns = this.table.getColumnCountInRow(tableRow);
            this.markColumns(tableRow, matchedRow, columns);
            this.lastMatchedRow = matchedRow;
        }
    }

    private void markColumns(int tableRow, int matchedRow, int columns) {
        for (int col = 0; col < columns; ++col) {
            this.markField(tableRow, matchedRow, col);
        }
    }

    @Override
    protected void markMatch(int tableRow, int matchedRow, int col) {
        if (col == 0 && matchedRow <= this.lastMatchedRow) {
            this.failMessage(0, tableRow, "out of order: row " + (matchedRow + 1));
        } else {
            this.pass(col, tableRow);
        }
    }
}

