/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.responders.run.slimResponder.SlimTestSystem;
import fitnesse.slimTables.ScenarioTable;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import fitnesse.wikitext.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class ScriptTable
extends SlimTable {
    private static final String SEQUENTIAL_ARGUMENT_PROCESSING_SUFFIX = ";";
    private Matcher symbolAssignmentMatcher;

    public ScriptTable(Table table, String tableId, SlimTestContext context) {
        super(table, tableId, context);
    }

    @Override
    protected String getTableType() {
        return "scriptTable";
    }

    @Override
    public void appendInstructions() {
        int rows = this.table.getRowCount();
        if (this.isScript() && this.table.getColumnCountInRow(0) > 1) {
            this.startActor(0);
        }
        for (int row = 1; row < rows; ++row) {
            this.appendInstructionForRow(row);
        }
    }

    private boolean isScript() {
        return "script".equalsIgnoreCase(this.table.getCellContents(0, 0));
    }

    private void appendInstructionForRow(int row) {
        String firstCell = this.table.getCellContents(0, row).trim();
        if (firstCell.equalsIgnoreCase("start")) {
            this.startActor(row);
        } else if (firstCell.equalsIgnoreCase("check")) {
            this.checkAction(row);
        } else if (firstCell.equalsIgnoreCase("check not")) {
            this.checkNotAction(row);
        } else if (firstCell.equalsIgnoreCase("reject")) {
            this.reject(row);
        } else if (firstCell.equalsIgnoreCase("ensure")) {
            this.ensure(row);
        } else if (firstCell.equalsIgnoreCase("show")) {
            this.show(row);
        } else if (firstCell.equalsIgnoreCase("note")) {
            this.note(row);
        } else if (this.isSymbolAssignment(firstCell)) {
            this.actionAndAssign(row);
        } else if (firstCell.length() == 0) {
            this.note(row);
        } else if (firstCell.trim().startsWith("#") || firstCell.trim().startsWith("*")) {
            this.note(row);
        } else {
            this.action(row);
        }
    }

    private void actionAndAssign(int row) {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        String symbolName = this.symbolAssignmentMatcher.group(1);
        this.addExpectation(new SlimTable.SymbolAssignmentExpectation(this, symbolName, this.getInstructionTag(), 0, row));
        String actionName = this.getActionNameStartingAt(1, lastCol, row);
        if (!actionName.equals("")) {
            String[] args = this.getArgumentsStartingAt(2, lastCol, row);
            this.callAndAssign(symbolName, "scriptTableActor", actionName, args);
        }
    }

    private boolean isSymbolAssignment(String firstCell) {
        this.symbolAssignmentMatcher = symbolAssignmentPattern.matcher(firstCell);
        return this.symbolAssignmentMatcher.matches();
    }

    private void action(int row) {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        String actionName = this.getActionNameStartingAt(0, lastCol, row);
        String[] args = this.getArgumentsStartingAt(1, lastCol, row);
        ScenarioTable scenario = this.getTestContext().getScenario(SlimTable.Disgracer.disgraceClassName(actionName));
        if (scenario != null) {
            scenario.call(args, this, row);
        } else if (!this.invokeParameterizedScenarioIfPossible(row)) {
            this.addExpectation(new ScriptActionExpectation(this.getInstructionTag(), 0, row));
            this.callFunction("scriptTableActor", actionName, args);
        }
    }

    private boolean invokeParameterizedScenarioIfPossible(int row) {
        if (this.table.getColumnCountInRow(row) == 1) {
            String firstNameCell = this.table.getCellContents(0, row);
            for (ScenarioTable scenario : this.getScenariosWithMostArgumentsFirst()) {
                String[] arguments = scenario.matchParameters(firstNameCell);
                if (arguments == null) continue;
                scenario.call(arguments, this, row);
                return true;
            }
        }
        return false;
    }

    private List<ScenarioTable> getScenariosWithMostArgumentsFirst() {
        Map<String, ScenarioTable> scenarioMap = this.getTestContext().getScenarios();
        ArrayList<ScenarioTable> scenarios = new ArrayList<ScenarioTable>(scenarioMap.values());
        Collections.sort(scenarios, new ScenarioTableLengthComparator());
        return scenarios;
    }

    private void note(int row) {
    }

    private void show(int row) {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        this.addExpectation(new ShowActionExpectation(this.getInstructionTag(), 0, row));
        this.invokeAction(1, lastCol, row);
    }

    private void ensure(int row) {
        this.addExpectation(new EnsureActionExpectation(this.getInstructionTag(), 0, row));
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        this.invokeAction(1, lastCol, row);
    }

    private void reject(int row) {
        this.addExpectation(new RejectActionExpectation(this.getInstructionTag(), 0, row));
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        this.invokeAction(1, lastCol, row);
    }

    private void checkAction(int row) {
        int lastColInAction = this.table.getColumnCountInRow(row) - 1;
        this.table.getCellContents(lastColInAction, row);
        this.addExpectation(new SlimTable.ReturnedValueExpectation(this, this.getInstructionTag(), lastColInAction, row));
        this.invokeAction(1, lastColInAction - 1, row);
    }

    private void checkNotAction(int row) {
        int lastColInAction = this.table.getColumnCountInRow(row) - 1;
        this.table.getCellContents(lastColInAction, row);
        this.addExpectation(new SlimTable.RejectedValueExpectation(this, this.getInstructionTag(), lastColInAction, row));
        this.invokeAction(1, lastColInAction - 1, row);
    }

    private void invokeAction(int startingCol, int endingCol, int row) {
        String actionName = this.getActionNameStartingAt(startingCol, endingCol, row);
        String[] args = this.getArgumentsStartingAt(startingCol + 1, endingCol, row);
        this.callFunction("scriptTableActor", actionName, args);
    }

    private String getActionNameStartingAt(int startingCol, int endingCol, int row) {
        StringBuffer actionName = new StringBuffer();
        actionName.append(this.table.getCellContents(startingCol, row));
        for (int actionNameCol = startingCol + 2; actionNameCol <= endingCol && !this.invokesSequentialArgumentProcessing(actionName.toString()); actionNameCol += 2) {
            actionName.append(" ").append(this.table.getCellContents(actionNameCol, row));
        }
        return actionName.toString().trim();
    }

    private String[] getArgumentsStartingAt(int startingCol, int endingCol, int row) {
        ArgumentExtractor extractor = new ArgumentExtractor(startingCol, endingCol, row);
        while (extractor.hasMoreToExtract()) {
            this.addExpectation(new ArgumentExpectation(this.getInstructionTag(), extractor.argumentColumn, row));
            extractor.extractNextArgument();
        }
        return extractor.getArguments();
    }

    private boolean invokesSequentialArgumentProcessing(String cellContents) {
        return cellContents.endsWith(SEQUENTIAL_ARGUMENT_PROCESSING_SUFFIX);
    }

    private void startActor(int row) {
        int classNameColumn = 1;
        String cellContents = this.table.getCellContents(classNameColumn, row);
        String className = SlimTable.Disgracer.disgraceClassName(cellContents);
        this.constructInstance("scriptTableActor", className, classNameColumn, row);
    }

    @Override
    public void evaluateReturnValues(Map<String, Object> returnValues) throws Exception {
    }

    private class ArgumentExpectation
    extends SlimTable.Expectation {
        private ArgumentExpectation(String instructionTag, int col, int row) {
            super(ScriptTable.this, instructionTag, col, row);
        }

        @Override
        public void evaluateExpectation(Map<String, Object> returnValues) {
            String originalContent = ScriptTable.this.table.getCellContents(this.getCol(), this.getRow());
            ScriptTable.this.table.setCell(this.getCol(), this.getRow(), ScriptTable.this.replaceSymbolsWithFullExpansion(originalContent));
        }

        @Override
        protected String createEvaluationMessage(String actual, String expected) {
            return null;
        }
    }

    private class ShowActionExpectation
    extends SlimTable.Expectation {
        public ShowActionExpectation(String instructionTag, int col, int row) {
            super(ScriptTable.this, instructionTag, col, row);
        }

        @Override
        protected String createEvaluationMessage(String actual, String expected) {
            try {
                ScriptTable.this.table.appendCellToRow(this.getRow(), Utils.escapeHTML(actual));
            }
            catch (Throwable e) {
                return ScriptTable.this.failMessage(actual, SlimTestSystem.exceptionToString(e));
            }
            return expected;
        }
    }

    private class RejectActionExpectation
    extends SlimTable.Expectation {
        public RejectActionExpectation(String instructionTag, int col, int row) {
            super(ScriptTable.this, instructionTag, col, row);
        }

        @Override
        protected String createEvaluationMessage(String actual, String expected) {
            if (actual == null) {
                return ScriptTable.this.pass(expected);
            }
            return actual.equals("false") ? ScriptTable.this.pass(expected) : ScriptTable.this.fail(expected);
        }
    }

    private class EnsureActionExpectation
    extends SlimTable.Expectation {
        public EnsureActionExpectation(String instructionTag, int col, int row) {
            super(ScriptTable.this, instructionTag, col, row);
        }

        @Override
        protected String createEvaluationMessage(String actual, String expected) {
            return actual != null && actual.equals("true") ? ScriptTable.this.pass(expected) : ScriptTable.this.fail(expected);
        }
    }

    private class ScriptActionExpectation
    extends SlimTable.Expectation {
        private ScriptActionExpectation(String instructionTag, int col, int row) {
            super(ScriptTable.this, instructionTag, col, row);
        }

        @Override
        protected String createEvaluationMessage(String actual, String expected) {
            if (actual == null) {
                return ScriptTable.this.failMessage(expected, "Returned null value.");
            }
            if (actual.equals("/__VOID__/") || actual.equals("null")) {
                return expected;
            }
            if (actual.equals("false")) {
                return ScriptTable.this.fail(expected);
            }
            if (actual.equals("true")) {
                return ScriptTable.this.pass(expected);
            }
            return expected;
        }
    }

    class ArgumentExtractor {
        private int argumentColumn;
        private int endingCol;
        private int row;
        private List<String> arguments = new ArrayList<String>();
        private int increment = 2;
        private boolean sequentialArguments = false;

        ArgumentExtractor(int startingCol, int endingCol, int row) {
            this.argumentColumn = startingCol;
            this.endingCol = endingCol;
            this.row = row;
        }

        public boolean hasMoreToExtract() {
            return this.argumentColumn <= this.endingCol;
        }

        public void extractNextArgument() {
            this.arguments.add(ScriptTable.this.table.getUnescapedCellContents(this.argumentColumn, this.row));
            String argumentKeyword = ScriptTable.this.table.getCellContents(this.argumentColumn - 1, this.row);
            boolean argumentIsSequential = ScriptTable.this.invokesSequentialArgumentProcessing(argumentKeyword);
            this.sequentialArguments = this.sequentialArguments || argumentIsSequential;
            this.increment = this.sequentialArguments ? 1 : 2;
            this.argumentColumn += this.increment;
        }

        public String[] getArguments() {
            return this.arguments.toArray(new String[this.arguments.size()]);
        }
    }

    private static class ScenarioTableLengthComparator
    implements Comparator<ScenarioTable> {
        private ScenarioTableLengthComparator() {
        }

        @Override
        public int compare(ScenarioTable st1, ScenarioTable st2) {
            int size1 = st1.getInputs().size();
            int size2 = st2.getInputs().size();
            return size2 - size1;
        }
    }
}

