/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.zip;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.NullVersionsController;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageVersionPruner;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPageProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import util.Clock;
import util.StreamReader;

public class ZipFileVersionsController
extends NullVersionsController {
    public static SimpleDateFormat dateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public ZipFileVersionsController() {
        this(new Properties());
    }

    public ZipFileVersionsController(Properties properties) {
    }

    @Override
    public PageData getRevisionData(FileSystemPage page, String label) {
        String filename = this.getFileSystemPath(page) + "/" + label + ".zip";
        File file = new File(filename);
        if (!file.exists()) {
            throw new NoSuchVersionException("There is no version '" + label + "'");
        }
        ZipFile zipFile = null;
        try {
            PageData data = new PageData(page);
            zipFile = new ZipFile(file);
            this.loadVersionContent(zipFile, data);
            this.loadVersionAttributes(zipFile, data);
            data.addVersions(this.loadVersions(page));
            PageData pageData = data;
            return pageData;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getFileSystemPath(FileSystemPage page) {
        try {
            return page.getFileSystemPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<VersionInfo> history(FileSystemPage page) {
        File dir = new File(this.getFileSystemPath(page));
        File[] files = dir.listFiles();
        HashSet<VersionInfo> versions = new HashSet<VersionInfo>();
        if (files != null) {
            for (File file : files) {
                if (!this.isVersionFile(file)) continue;
                versions.add(new VersionInfo(this.makeVersionName(file)));
            }
        }
        return versions;
    }

    public boolean isRevisionControlEnabled() {
        return true;
    }

    @Override
    public boolean isExternalRevisionControlEnabled() {
        return false;
    }

    @Override
    public VersionInfo makeVersion(FileSystemPage page, PageData data) {
        String dirPath = this.getFileSystemPath(page);
        Set<File> filesToZip = this.getFilesToZip(dirPath);
        VersionInfo version = this.makeVersionInfo(data);
        if (filesToZip.size() == 0) {
            return new VersionInfo("first_commit", "", Clock.currentDate());
        }
        ZipOutputStream zos = null;
        try {
            String filename = this.makeVersionFileName(page, version.getName());
            zos = new ZipOutputStream(new FileOutputStream(filename));
            for (File aFilesToZip : filesToZip) {
                this.addToZip(aFilesToZip, zos);
            }
            VersionInfo versionInfo = new VersionInfo(version.getName());
            return versionInfo;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                if (zos != null) {
                    zos.finish();
                    zos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void prune(FileSystemPage page) {
        try {
            PageVersionPruner.pruneVersions(page, this.history(page));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeVersion(FileSystemPage page, String versionName) {
        String versionFileName = this.makeVersionFileName(page, versionName);
        File versionFile = new File(versionFileName);
        versionFile.delete();
    }

    private void addToZip(File file, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(file.getName());
        zos.putNextEntry(entry);
        FileInputStream is = new FileInputStream(file);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        is.read(bytes);
        is.close();
        zos.write(bytes, 0, size);
    }

    private Set<File> getFilesToZip(String dirPath) {
        HashSet<File> filesToZip = new HashSet<File>();
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return filesToZip;
        }
        for (File file : files) {
            if (this.isVersionFile(file) || file.isDirectory()) continue;
            filesToZip.add(file);
        }
        return filesToZip;
    }

    private boolean isVersionFile(File file) {
        return Pattern.matches("(\\S+)?\\d+\\.zip", file.getName());
    }

    private void loadVersionAttributes(ZipFile zipFile, PageData data) {
        ZipEntry attributes = zipFile.getEntry("properties.xml");
        if (attributes != null) {
            InputStream attributeIS = null;
            try {
                attributeIS = zipFile.getInputStream(attributes);
                WikiPageProperties props = new WikiPageProperties(attributeIS);
                data.setProperties(props);
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            finally {
                try {
                    if (attributeIS != null) {
                        attributeIS.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadVersionContent(ZipFile zipFile, PageData data) {
        String content = "";
        ZipEntry contentEntry = zipFile.getEntry("content.txt");
        if (contentEntry != null) {
            StreamReader reader = null;
            try {
                InputStream contentIS = zipFile.getInputStream(contentEntry);
                reader = new StreamReader(contentIS);
                content = reader.read((int)contentEntry.getSize());
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        data.setContent(content);
    }

    private Collection<VersionInfo> loadVersions(FileSystemPage page) {
        File dir = new File(this.getFileSystemPath(page));
        File[] files = dir.listFiles();
        HashSet<VersionInfo> versions = new HashSet<VersionInfo>();
        if (files != null) {
            for (File file : files) {
                if (!this.isVersionFile(file)) continue;
                versions.add(new VersionInfo(this.makeVersionName(file)));
            }
        }
        return versions;
    }

    private String makeVersionFileName(FileSystemPage page, String name) {
        return this.getFileSystemPath(page) + "/" + name + ".zip";
    }

    private VersionInfo makeVersionInfo(PageData data) {
        try {
            Date time = data.getProperties().getLastModificationTime();
            String versionName = VersionInfo.nextId() + "-" + ZipFileVersionsController.dateFormat().format(time);
            String user = data.getAttribute("LastModifyingUser");
            if (user != null && !"".equals(user)) {
                versionName = user + "-" + versionName;
            }
            return new VersionInfo(versionName, user, time);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String makeVersionName(File file) {
        String name = file.getName();
        return name.substring(0, name.length() - 4);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getControllerName() {
        return "Zipped Version History";
    }
}

