/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.SystemTimeKeeper;

public class LastModified
extends SymbolType
implements Translation {
    public LastModified() {
        super("LastModified");
        this.wikiMatcher(new Matcher().string("!lastmodified"));
        this.htmlTranslation(this);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        String user = translator.getPage().getProperty("LastModifyingUser");
        String date = translator.getPage().getProperty("LastModified");
        return translator.formatMessage("Last modified " + (user.length() > 0 ? "by " + user : "anonymously") + " on " + this.formatDate(date));
    }

    private String formatDate(String dateString) {
        Date date;
        if (dateString.length() == 0) {
            date = SystemTimeKeeper.now();
        } else {
            try {
                date = WikiPageProperties.getTimeFormat().parse(dateString);
            }
            catch (ParseException e) {
                return dateString;
            }
        }
        return new SimpleDateFormat("MMM dd, yyyy").format(date) + " at " + new SimpleDateFormat("hh:mm:ss a").format(date);
    }
}

