/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.ScanString;
import java.util.ArrayList;
import java.util.List;
import util.Maybe;

public class Matcher {
    private static final ArrayList<Character> defaultList = new ArrayList();
    private ArrayList<ScanMatch> matches = new ArrayList();
    private ArrayList<Character> firsts = null;

    public List<Character> getFirsts() {
        return this.firsts != null ? this.firsts : defaultList;
    }

    public Matcher whitespace() {
        if (this.firsts == null) {
            this.firsts = defaultList;
        }
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                int length = input.whitespaceLength(offset);
                return length > 0 ? new Maybe<Integer>(length) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher startLine() {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                return input.startsLine(offset) ? new Maybe<Integer>(0) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher startLineOrCell() {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                return input.startsLine(offset, "\n|") ? new Maybe<Integer>(0) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher string(final String delimiter) {
        if (this.firsts == null) {
            this.firsts = new ArrayList();
            this.firsts.add(Character.valueOf(delimiter.charAt(0)));
        }
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                return input.matches(delimiter, offset) ? new Maybe<Integer>(delimiter.length()) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher digit() {
        this.firstIsDigit();
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                return Matcher.this.isDigitInput(input, offset) ? new Maybe<Integer>(1) : Maybe.noInteger;
            }
        });
        return this;
    }

    private boolean isDigitInput(ScanString input, int offset) {
        for (char i = '1'; i <= '9'; i = (char)((char)(i + 1))) {
            if (!input.matches(new String(new char[]{i}), offset)) continue;
            return true;
        }
        return false;
    }

    private void firstIsDigit() {
        if (this.firsts == null) {
            this.firsts = new ArrayList();
            for (char i = '1'; i <= '9'; i = (char)(i + '\u0001')) {
                this.firsts.add(Character.valueOf(i));
            }
        }
    }

    public Matcher digits() {
        this.firstIsDigit();
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                int size = 0;
                while (Matcher.this.isDigitInput(input, offset + size)) {
                    ++size;
                }
                return size > 0 ? new Maybe<Integer>(size) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher ignoreWhitespace() {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                return new Maybe<Integer>(input.whitespaceLength(offset));
            }
        });
        return this;
    }

    public Matcher repeat(final char delimiter) {
        if (this.firsts == null) {
            this.firsts = new ArrayList();
            this.firsts.add(Character.valueOf(delimiter));
        }
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                int size = 0;
                while (input.charAt(offset + size) == delimiter) {
                    ++size;
                }
                return size > 0 ? new Maybe<Integer>(size) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher endsWith(final char[] terminators) {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, int offset) {
                int size = 0;
                while (true) {
                    char candidate;
                    if ((candidate = input.charAt(offset + size)) == '\u0000') {
                        return Maybe.noInteger;
                    }
                    if (this.contains(terminators, candidate)) break;
                    ++size;
                }
                return size > 0 ? new Maybe<Integer>(size + 1) : Maybe.noInteger;
            }

            private boolean contains(char[] terminators2, char candidate) {
                for (char terminator : terminators2) {
                    if (candidate != terminator) continue;
                    return true;
                }
                return false;
            }
        });
        return this;
    }

    public Maybe<Integer> makeMatch(ScanString input) {
        int totalLength = 0;
        for (ScanMatch match : this.matches) {
            Maybe<Integer> matchLength = match.match(input, totalLength);
            if (matchLength.isNothing()) {
                return Maybe.noInteger;
            }
            totalLength += matchLength.getValue().intValue();
        }
        return new Maybe<Integer>(totalLength);
    }

    static {
        defaultList.add(Character.valueOf('\u0000'));
    }

    private static interface ScanMatch {
        public Maybe<Integer> match(ScanString var1, int var2);
    }
}

