/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fit.FitServer;
import fitnesse.components.CommandRunner;
import fitnesse.components.FitClient;
import fitnesse.responders.run.SocketDealer;
import fitnesse.responders.run.SocketDoner;
import fitnesse.responders.run.SocketSeeker;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.testutil.MockCommandRunner;
import java.net.InetAddress;
import java.util.Map;

public class CommandRunningFitClient
extends FitClient
implements SocketSeeker {
    public static int TIMEOUT = 60000;
    private static final String SPACE = " ";
    private int ticketNumber;
    public CommandRunner commandRunner;
    private SocketDoner donor;
    private boolean connectionEstablished = false;
    private Thread timeoutThread;
    private Thread earlyTerminationThread;
    private boolean fastTest = false;
    private Thread fastFitServer;

    public CommandRunningFitClient(TestSystemListener listener, String command, int port, SocketDealer dealer, boolean fastTest) throws Exception {
        this(listener, command, port, null, dealer, fastTest);
    }

    public CommandRunningFitClient(TestSystemListener listener, String command, int port, Map<String, String> environmentVariables, SocketDealer dealer, boolean fastTest) throws Exception {
        super(listener);
        this.fastTest = fastTest;
        this.ticketNumber = dealer.seekingSocket(this);
        String hostName = InetAddress.getLocalHost().getHostName();
        String fitArguments = hostName + SPACE + port + SPACE + this.ticketNumber;
        String commandLine = command + SPACE + fitArguments;
        if (fastTest) {
            this.commandRunner = new MockCommandRunner();
            this.createFitServer("-x " + fitArguments);
        } else {
            this.commandRunner = new CommandRunner(commandLine, "", environmentVariables);
        }
    }

    public CommandRunningFitClient(TestSystemListener listener, String command, int port, SocketDealer dealer) throws Exception {
        this(listener, command, port, null, dealer);
    }

    public CommandRunningFitClient(TestSystemListener listener, String command, int port, Map<String, String> environmentVariables, SocketDealer dealer) throws Exception {
        this(listener, command, port, environmentVariables, dealer, false);
    }

    void createFitServer(String args) throws Exception {
        final String fitArgs = args;
        Runnable fastFitServerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (!CommandRunningFitClient.this.tryCreateFitServer(fitArgs)) {
                        Thread.sleep(10L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.fastFitServer = new Thread(fastFitServerRunnable);
        this.fastFitServer.start();
    }

    private boolean tryCreateFitServer(String args) throws Exception {
        try {
            FitServer.main(args.trim().split(SPACE));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void start() throws Exception {
        try {
            this.commandRunner.asynchronousStart();
            if (!this.fastTest) {
                this.timeoutThread = new Thread((Runnable)new TimeoutRunnable(), "FitClient timeout");
                this.timeoutThread.start();
                this.earlyTerminationThread = new Thread((Runnable)new EarlyTerminationRunnable(), "FitClient early termination");
                this.earlyTerminationThread.start();
            }
            this.waitForConnection();
        }
        catch (Exception e) {
            this.listener.exceptionOccurred(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptSocketFrom(SocketDoner donor) throws Exception {
        this.donor = donor;
        this.acceptSocket(donor.donateSocket());
        this.connectionEstablished = true;
        CommandRunningFitClient commandRunningFitClient = this;
        synchronized (commandRunningFitClient) {
            this.notify();
        }
    }

    void setTicketNumber(int ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    public boolean isSuccessfullyStarted() {
        return this.fitSocket != null;
    }

    private void waitForConnection() throws InterruptedException {
        while (this.fitSocket == null) {
            Thread.sleep(100L);
            this.checkForPulse();
        }
    }

    @Override
    public void join() throws Exception {
        try {
            if (this.fastTest) {
                this.fastFitServer.join();
            } else {
                this.commandRunner.join();
            }
            super.join();
            if (this.donor != null) {
                this.donor.finishedWithSocket();
            }
            this.killVigilantThreads();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void kill() throws Exception {
        super.kill();
        this.killVigilantThreads();
        this.commandRunner.kill();
    }

    private void killVigilantThreads() {
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
        if (this.earlyTerminationThread != null) {
            this.earlyTerminationThread.interrupt();
        }
    }

    @Override
    public void exceptionOccurred(Exception e) {
        this.commandRunner.exceptionOccurred(e);
        super.exceptionOccurred(e);
    }

    private class EarlyTerminationRunnable
    implements Runnable {
        private EarlyTerminationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                CommandRunningFitClient.this.commandRunner.process.waitFor();
                CommandRunningFitClient commandRunningFitClient = CommandRunningFitClient.this;
                synchronized (commandRunningFitClient) {
                    if (!CommandRunningFitClient.this.connectionEstablished) {
                        CommandRunningFitClient.this.notify();
                        CommandRunningFitClient.this.listener.exceptionOccurred(new Exception("FitClient: external process terminated before a connection could be established."));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class TimeoutRunnable
    implements Runnable {
        long timeSlept = 0L;

        private TimeoutRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(TIMEOUT);
                CommandRunningFitClient commandRunningFitClient = CommandRunningFitClient.this;
                synchronized (commandRunningFitClient) {
                    if (CommandRunningFitClient.this.fitSocket == null) {
                        CommandRunningFitClient.this.notify();
                        CommandRunningFitClient.this.listener.exceptionOccurred(new Exception("FitClient: communication socket was not received on time."));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

