/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.RawHtml;
import java.util.LinkedList;
import java.util.List;

public class HtmlTag
extends HtmlElement {
    public LinkedList<HtmlElement> childTags = new LinkedList();
    protected List<Attribute> attributes = new LinkedList<Attribute>();
    protected String tagName = "youreIt";
    public String tail;
    public String head;
    public boolean isInline;

    public HtmlTag(String tagName) {
        this.tagName = tagName;
    }

    public HtmlTag(String tagName, String content) {
        this(tagName);
        this.add(content);
    }

    public HtmlTag(String tagName, HtmlElement child) {
        this(tagName);
        this.add(child);
    }

    public String tagName() {
        return this.tagName;
    }

    @Override
    public String html() {
        return this.html(0);
    }

    public String htmlInline() {
        this.isInline = true;
        return this.html(0);
    }

    public String html(int depth) {
        return new HtmlFormatter(depth).format();
    }

    private boolean hasChildren() {
        return this.childTags.size() > 0;
    }

    public void add(String s) {
        this.add(new RawHtml(s));
    }

    public void add(HtmlElement element) {
        this.childTags.add(element);
    }

    public void addAttribute(String key, String value) {
        this.attributes.add(new Attribute(key, value));
    }

    public void use(String s) {
        this.use(new RawHtml(s));
    }

    public void use(HtmlElement element) {
        this.childTags.clear();
        this.add(element);
    }

    public String getAttribute(String key) {
        for (Attribute attribute : this.attributes) {
            if (key == null || !key.equals(attribute.name)) continue;
            return attribute.value;
        }
        return null;
    }

    protected String makeIndent(int depth) {
        String indent = "";
        for (int i = 0; i < depth; ++i) {
            indent = indent + '\t';
        }
        return indent;
    }

    private class HtmlFormatter {
        private int depth;

        public HtmlFormatter(int depth) {
            this.depth = depth;
        }

        public String format() {
            return this.makeTabs() + this.makeHead() + this.makeTag() + this.makeAttributes() + this.makeTagEnd() + this.makeChildren() + this.makeEndTag() + this.makeTail() + this.makeLineEnd();
        }

        private String makeEndTag() {
            return HtmlTag.this.hasChildren() ? "</" + HtmlTag.this.tagName() + ">" : "";
        }

        private String makeLineEnd() {
            return HtmlTag.this.isInline ? "" : HtmlElement.endl;
        }

        private String makeTail() {
            return HtmlTag.this.tail == null ? "" : HtmlTag.this.tail;
        }

        private String makeChildren() {
            String children = "";
            if (HtmlTag.this.hasChildren()) {
                boolean addedTag = false;
                boolean lastAddedWasNonTag = false;
                int i1 = 0;
                for (HtmlElement element : HtmlTag.this.childTags) {
                    if (element instanceof HtmlTag) {
                        if ((i1 == 0 || lastAddedWasNonTag) && !HtmlTag.this.isInline) {
                            children = children + HtmlElement.endl;
                        }
                        children = children + ((HtmlTag)element).html(this.depth + 1);
                        addedTag = true;
                        lastAddedWasNonTag = false;
                    } else {
                        children = children + element.html();
                        lastAddedWasNonTag = true;
                    }
                    ++i1;
                }
                boolean tagWasAdded = addedTag;
                if (tagWasAdded && !HtmlTag.this.isInline) {
                    children = children + this.makeTabs();
                }
            }
            return children;
        }

        private String makeTagEnd() {
            return HtmlTag.this.hasChildren() ? ">" : "/>";
        }

        private String makeAttributes() {
            String attributes = "";
            for (Attribute attribute : HtmlTag.this.attributes) {
                attributes = attributes + " " + attribute.name + "=\"" + attribute.value + "\"";
            }
            return attributes;
        }

        private String makeTag() {
            return "<" + HtmlTag.this.tagName();
        }

        private String makeHead() {
            return HtmlTag.this.head == null ? "" : HtmlTag.this.head;
        }

        private String makeTabs() {
            return HtmlTag.this.makeIndent(this.depth);
        }
    }

    public static class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

