/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.http.RequestBuilder;
import fitnesse.http.ResponseParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import util.CommandLine;
import util.FileUtil;

public class FormattingOption {
    public String format;
    public boolean usingStdout = false;
    public OutputStream output;
    public String host;
    public int port;
    public String rootPath;
    private int status;
    public String filename;
    private String resultFilename;

    public static void main(String[] args) throws Exception {
        FormattingOption option = new FormattingOption();
        option.args(args);
        File inputFile = new File(option.resultFilename);
        FileInputStream input = new FileInputStream(inputFile);
        int byteCount = (int)inputFile.length();
        option.process(input, byteCount);
    }

    private FormattingOption() {
    }

    private void args(String[] args) throws Exception {
        CommandLine commandLine = new CommandLine("resultFilename format outputFilename host port rootPath");
        if (!commandLine.parse(args)) {
            this.usage();
        }
        this.resultFilename = commandLine.getArgument("resultFilename");
        this.format = commandLine.getArgument("format");
        this.filename = commandLine.getArgument("outputFilename");
        this.host = commandLine.getArgument("host");
        this.port = Integer.parseInt(commandLine.getArgument("port"));
        this.rootPath = commandLine.getArgument("rootPath");
        this.setOutput(System.out);
    }

    private void usage() {
        System.out.println("java fitnesse.runner.FormattingOption resultFilename format outputFilename host port rootPath");
        System.out.println("\tresultFilename:\tthe name of the file containing test results");
        System.out.println("\tformat:        \traw|html|xml|...");
        System.out.println("\toutputfilename:\tstdout|a filename where the formatted results are to be stored");
        System.out.println("\thost:          \tthe domain name of the hosting FitNesse server");
        System.out.println("\tport:          \tthe port on which the hosting FitNesse server is running");
        System.out.println("\trootPath:      \tname of the test page or suite page");
        System.exit(-1);
    }

    public FormattingOption(String format, String filename, OutputStream stdout, String host, int port, String rootPath) throws Exception {
        this.format = format;
        this.filename = filename;
        this.setOutput(stdout);
        this.host = host;
        this.port = port;
        this.rootPath = rootPath;
    }

    private void setOutput(OutputStream stdout) throws FileNotFoundException {
        if ("stdout".equals(this.filename)) {
            this.output = stdout;
            this.usingStdout = true;
        } else {
            this.output = new FileOutputStream(this.filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputStream inputStream, int size) throws Exception {
        try {
            if ("raw".equals(this.format)) {
                FileUtil.copyBytes(inputStream, this.output);
            } else {
                RequestBuilder request = this.buildRequest(inputStream, size);
                ResponseParser response = ResponseParser.performHttpRequest(this.host, this.port, request);
                this.status = response.getStatus();
                this.output.write(response.getBody().getBytes("UTF-8"));
            }
        }
        finally {
            if (!this.usingStdout) {
                this.output.close();
            }
        }
    }

    public boolean wasSuccessful() {
        return this.status == 200;
    }

    public RequestBuilder buildRequest(InputStream inputStream, int size) throws Exception {
        RequestBuilder request = new RequestBuilder("/" + this.rootPath);
        request.setMethod("POST");
        request.setHostAndPort(this.host, this.port);
        request.addInput("responder", "format");
        request.addInput("format", this.format);
        request.addInputAsPart("results", inputStream, size, "text/plain");
        return request;
    }
}

