/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimClient;
import fitnesse.slim.SlimService;
import fitnesse.slim.SlimVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public abstract class SlimServiceTestBase {
    protected List<Object> statements;
    protected SlimClient slimClient;

    protected abstract void startSlimService() throws Exception;

    protected abstract String getImport();

    protected abstract String expectedExceptionMessage();

    protected abstract String expectedStopTestExceptionMessage();

    @Before
    public void setUp() throws Exception {
        this.createSlimService();
        this.slimClient = new SlimClient("localhost", 8099);
        this.statements = new ArrayList<Object>();
        this.slimClient.connect();
    }

    protected void createSlimService() throws Exception {
        while (!this.tryCreateSlimService()) {
            Thread.sleep(10L);
        }
    }

    private boolean tryCreateSlimService() throws Exception {
        try {
            this.startSlimService();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @After
    public void after() throws Exception {
        this.teardown();
    }

    protected void teardown() throws Exception {
        this.slimClient.sendBye();
        this.slimClient.close();
    }

    @Test
    public void emptySession() throws Exception {
        Assert.assertTrue((String)"Connected", (boolean)this.slimClient.isConnected());
    }

    @Test
    public void versionNumberShouldBeDetected() throws Exception {
        double slimVersion = Double.parseDouble(SlimVersion.VERSION);
        Assert.assertEquals((double)slimVersion, (double)this.slimClient.getServerVersion(), (double)1.0E-4);
    }

    @Test
    public void callOneMethod() throws Exception {
        this.addImportAndMake();
        this.addEchoInt("id", "1");
        Map<String, Object> result = this.slimClient.invokeAndGetResponse(this.statements);
        Assert.assertEquals((Object)"1", (Object)result.get("id"));
    }

    private void addEchoInt(String id, String number) {
        this.statements.add(ListUtility.list(id, "call", "testSlim", "echoInt", number));
    }

    private void addImportAndMake() {
        this.statements.add(ListUtility.list("i1", "import", this.getImport()));
        this.statements.add(ListUtility.list("m1", "make", "testSlim", "TestSlim"));
    }

    @Test
    public void makeManyCallsInOrderToTestLongSequencesOfInstructions() throws Exception {
        this.addImportAndMake();
        for (int i = 0; i < 1000; ++i) {
            this.addEchoInt(String.format("id_%d", i), Integer.toString(i));
        }
        Map<String, Object> result = this.slimClient.invokeAndGetResponse(this.statements);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)i, (long)Integer.parseInt((String)result.get(String.format("id_%d", i))));
        }
    }

    @Test
    public void callWithLineBreakInStringArgument() throws Exception {
        this.addImportAndMake();
        this.statements.add(ListUtility.list("id", "call", "testSlim", "echoString", "hello\nworld\n"));
        Map<String, Object> result = this.slimClient.invokeAndGetResponse(this.statements);
        Assert.assertEquals((Object)"hello\nworld\n", (Object)result.get("id"));
    }

    @Test
    public void callWithMultiByteChar() throws Exception {
        this.addImportAndMake();
        this.statements.add(ListUtility.list("id", "call", "testSlim", "echoString", "K\u00f6ln"));
        Map<String, Object> result = this.slimClient.invokeAndGetResponse(this.statements);
        Assert.assertEquals((Object)"K\u00f6ln", (Object)result.get("id"));
    }

    @Test
    public void makeManyIndividualCalls() throws Exception {
        this.addImportAndMake();
        this.slimClient.invokeAndGetResponse(this.statements);
        for (int i = 0; i < 100; ++i) {
            this.statements.clear();
            this.addEchoInt("id", "42");
            Map<String, Object> result = this.slimClient.invokeAndGetResponse(this.statements);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"42", (Object)result.get("id"));
        }
    }

    @Test
    public void callFunctionThatDoesntExist() throws Exception {
        this.addImportAndMake();
        this.statements.add(ListUtility.list("id", "call", "testSlim", "noSuchFunction"));
        Map<String, Object> results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("message:<<NO_METHOD_IN_CLASS", "id", results);
    }

    private void assertContainsException(String message, String id, Map<String, Object> results) {
        String result;
        Assert.assertTrue((String)result, ((result = (String)results.get(id)).indexOf("__EXCEPTION__:") != -1 && result.indexOf(message) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void makeClassThatDoesntExist() throws Exception {
        this.statements.add(ListUtility.list("m1", "make", "me", "NoSuchClass"));
        Map<String, Object> results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR", "m1", results);
    }

    @Test
    public void useInstanceThatDoesntExist() throws Exception {
        this.addImportAndMake();
        this.statements.add(ListUtility.list("id", "call", "noInstance", "f"));
        Map<String, Object> results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("message:<<NO_INSTANCE", "id", results);
    }

    @Test
    public void verboseArgument() throws Exception {
        String[] args = new String[]{"-v", "99"};
        Assert.assertTrue((boolean)SlimService.parseCommandLine(args));
        Assert.assertTrue((boolean)SlimService.verbose);
    }

    @Test
    public void notStopTestExceptionThrown() throws Exception {
        this.addImportAndMake();
        this.statements.add(ListUtility.list("id", "call", "testSlim", "throwNormal"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "throwNormal"));
        Map<String, Object> results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("__EXCEPTION__:" + this.expectedExceptionMessage(), "id", results);
        this.assertContainsException("__EXCEPTION__:" + this.expectedExceptionMessage(), "id2", results);
    }

    @Test
    public void stopTestExceptionThrown() throws Exception {
        this.addImportAndMake();
        this.statements.add(ListUtility.list("id", "call", "testSlim", "throwStopping"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "throwNormal"));
        Map<String, Object> results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("__EXCEPTION__:" + this.expectedStopTestExceptionMessage(), "id", results);
        Assert.assertNull((Object)results.get("id2"));
    }
}

