/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.Extension;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.LinkedList;
import java.util.List;

public class SymbolicPage
extends BaseWikiPage {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "SymbolicLinks";
    private WikiPage realPage;

    public SymbolicPage(String name, WikiPage realPage, WikiPage parent) {
        super(name, parent);
        this.realPage = realPage;
    }

    public WikiPage getRealPage() {
        return this.realPage;
    }

    @Override
    public WikiPage addChildPage(String name) throws Exception {
        return this.realPage.addChildPage(name);
    }

    @Override
    public boolean hasChildPage(String name) throws Exception {
        return this.realPage.hasChildPage(name);
    }

    @Override
    protected WikiPage getNormalChildPage(String name) throws Exception {
        WikiPage childPage = this.realPage.getChildPage(name);
        if (childPage != null && !(childPage instanceof SymbolicPage)) {
            childPage = new SymbolicPage(name, childPage, this);
        }
        return childPage;
    }

    @Override
    protected WikiPage createInternalSymbolicPage(String linkPath, String linkName) throws Exception {
        WikiPagePath path = PathParser.parse(linkPath);
        WikiPage start = path.isRelativePath() ? this.getRealPage().getParent() : this.getRealPage();
        WikiPage page = this.getPageCrawler().getPage(start, path);
        if (page != null) {
            page = new SymbolicPage(linkName, page, this);
        }
        return page;
    }

    @Override
    public void removeChildPage(String name) throws Exception {
        this.realPage.removeChildPage(name);
    }

    @Override
    public List<WikiPage> getNormalChildren() throws Exception {
        List<WikiPage> children = this.realPage.getChildren();
        LinkedList<WikiPage> symChildren = new LinkedList<WikiPage>();
        for (WikiPage child : children) {
            symChildren.add(new SymbolicPage(child.getName(), child, this));
        }
        return symChildren;
    }

    @Override
    public PageData getData() throws Exception {
        PageData data = this.realPage.getData();
        data.setWikiPage(this);
        return data;
    }

    @Override
    public PageData getDataVersion(String versionName) throws Exception {
        PageData data = this.realPage.getDataVersion(versionName);
        data.setWikiPage(this);
        return data;
    }

    @Override
    public VersionInfo commit(PageData data) throws Exception {
        return this.realPage.commit(data);
    }

    @Override
    public boolean hasExtension(String extensionName) {
        return this.realPage.hasExtension(extensionName);
    }

    @Override
    public Extension getExtension(String extensionName) {
        return this.realPage.getExtension(extensionName);
    }
}

