/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDGlyphSetWidget;
import org.netbeans.api.visual.vmd.VMDMinimizeAbility;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMDNodeWidget
extends Widget
implements StateModel.Listener,
VMDMinimizeAbility {
    private Widget header;
    private ImageWidget minimizeWidget;
    private ImageWidget imageWidget;
    private LabelWidget nameWidget;
    private LabelWidget typeWidget;
    private VMDGlyphSetWidget glyphSetWidget;
    private SeparatorWidget pinsSeparator;
    private HashMap<String, Widget> pinCategoryWidgets = new HashMap();
    private StateModel stateModel = new StateModel(2);
    private Anchor nodeAnchor;
    private VMDColorScheme scheme;
    private WeakHashMap<Anchor, Anchor> proxyAnchorCache = new WeakHashMap();

    public VMDNodeWidget(Scene scene) {
        this(scene, VMDFactory.getOriginalScheme());
    }

    public VMDNodeWidget(Scene scene, VMDColorScheme scheme) {
        super(scene);
        assert (scheme != null);
        this.scheme = scheme;
        this.nodeAnchor = new VMDNodeAnchor(this, true, scheme);
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setMinimumSize(new Dimension(128, 8));
        this.header = new Widget(scene);
        this.header.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.CENTER, 8));
        this.addChild(this.header);
        boolean right = scheme.isNodeMinimizeButtonOnRight(this);
        this.minimizeWidget = new ImageWidget(scene, scheme.getMinimizeWidgetImage(this));
        this.minimizeWidget.setCursor(Cursor.getPredefinedCursor(12));
        this.minimizeWidget.getActions().addAction(new ToggleMinimizedAction());
        if (!right) {
            this.header.addChild(this.minimizeWidget);
        }
        this.imageWidget = new ImageWidget(scene);
        this.header.addChild(this.imageWidget);
        this.nameWidget = new LabelWidget(scene);
        this.nameWidget.setFont(scene.getDefaultFont().deriveFont(1));
        this.header.addChild(this.nameWidget);
        this.typeWidget = new LabelWidget(scene);
        this.typeWidget.setForeground(Color.BLACK);
        this.header.addChild(this.typeWidget);
        this.glyphSetWidget = new VMDGlyphSetWidget(scene);
        this.header.addChild(this.glyphSetWidget);
        if (right) {
            Widget widget = new Widget(scene);
            widget.setOpaque(false);
            this.header.addChild(widget, 1000);
            this.header.addChild(this.minimizeWidget);
        }
        this.pinsSeparator = new SeparatorWidget(scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.addChild(this.pinsSeparator);
        Widget topLayer = new Widget(scene);
        this.addChild(topLayer);
        this.stateModel = new StateModel();
        this.stateModel.addListener(this);
        scheme.installUI(this);
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    protected boolean isMinimizableWidget(Widget widget) {
        return true;
    }

    public boolean isMinimized() {
        return this.stateModel.getBooleanState();
    }

    public void setMinimized(boolean minimized) {
        this.stateModel.setBooleanState(minimized);
    }

    public void toggleMinimized() {
        this.stateModel.toggleBooleanState();
    }

    @Override
    public void stateChanged() {
        boolean minimized = this.stateModel.getBooleanState();
        Rectangle rectangle = minimized ? new Rectangle() : null;
        for (Widget widget : this.getChildren()) {
            if (widget == this.header || widget == this.pinsSeparator) continue;
            this.getScene().getSceneAnimator().animatePreferredBounds(widget, minimized && this.isMinimizableWidget(widget) ? rectangle : null);
        }
        this.minimizeWidget.setImage(this.scheme.getMinimizeWidgetImage(this));
    }

    @Override
    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.scheme.updateUI(this, previousState, state);
    }

    public void setNodeImage(Image image) {
        this.imageWidget.setImage(image);
        this.revalidate();
    }

    public String getNodeName() {
        return this.nameWidget.getLabel();
    }

    public void setNodeName(String nodeName) {
        this.nameWidget.setLabel(nodeName);
    }

    public void setNodeType(String nodeType) {
        this.typeWidget.setLabel(nodeType != null ? "[" + nodeType + "]" : null);
    }

    public void attachPinWidget(Widget widget) {
        widget.setCheckClipping(true);
        this.addChild(widget);
        if (this.stateModel.getBooleanState() && this.isMinimizableWidget(widget)) {
            widget.setPreferredBounds(new Rectangle());
        }
    }

    public void setGlyphs(List<Image> glyphs) {
        this.glyphSetWidget.setGlyphs(glyphs);
    }

    public void setNodeProperties(Image image, String nodeName, String nodeType, List<Image> glyphs) {
        this.setNodeImage(image);
        this.setNodeName(nodeName);
        this.setNodeType(nodeType);
        this.setGlyphs(glyphs);
    }

    public LabelWidget getNodeNameWidget() {
        return this.nameWidget;
    }

    public Anchor getNodeAnchor() {
        return this.nodeAnchor;
    }

    public Anchor createAnchorPin(Anchor anchor) {
        Anchor proxyAnchor = this.proxyAnchorCache.get(anchor);
        if (proxyAnchor == null) {
            proxyAnchor = AnchorFactory.createProxyAnchor(this.stateModel, anchor, this.nodeAnchor);
            this.proxyAnchorCache.put(anchor, proxyAnchor);
        }
        return proxyAnchor;
    }

    private List<Widget> getPinWidgets() {
        ArrayList<Widget> pins = new ArrayList<Widget>(this.getChildren());
        pins.remove(this.header);
        pins.remove(this.pinsSeparator);
        return pins;
    }

    public void sortPins(HashMap<String, List<Widget>> pinsCategories) {
        List<Widget> previousPins = this.getPinWidgets();
        ArrayList<Widget> unresolvedPins = new ArrayList<Widget>(previousPins);
        Iterator<Widget> iterator = unresolvedPins.iterator();
        while (iterator.hasNext()) {
            Widget widget = iterator.next();
            if (!this.pinCategoryWidgets.containsValue(widget)) continue;
            iterator.remove();
        }
        ArrayList<String> unusedCategories = new ArrayList<String>(this.pinCategoryWidgets.keySet());
        ArrayList<String> categoryNames = new ArrayList<String>(pinsCategories.keySet());
        Collections.sort(categoryNames);
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        for (String categoryName : categoryNames) {
            if (categoryName == null) continue;
            unusedCategories.remove(categoryName);
            newWidgets.add(this.createPinCategoryWidget(categoryName));
            List<Widget> widgets = pinsCategories.get(categoryName);
            for (Widget widget : widgets) {
                if (!unresolvedPins.remove(widget)) continue;
                newWidgets.add(widget);
            }
        }
        if (!unresolvedPins.isEmpty()) {
            newWidgets.addAll(0, unresolvedPins);
        }
        for (String category : unusedCategories) {
            this.pinCategoryWidgets.remove(category);
        }
        this.removeChildren(previousPins);
        this.addChildren(newWidgets);
    }

    private Widget createPinCategoryWidget(String categoryDisplayName) {
        Widget w = this.pinCategoryWidgets.get(categoryDisplayName);
        if (w != null) {
            return w;
        }
        Widget label = this.scheme.createPinCategoryWidget(this, categoryDisplayName);
        if (this.stateModel.getBooleanState()) {
            label.setPreferredBounds(new Rectangle());
        }
        this.pinCategoryWidgets.put(categoryDisplayName, label);
        return label;
    }

    @Override
    public void collapseWidget() {
        this.stateModel.setBooleanState(true);
    }

    @Override
    public void expandWidget() {
        this.stateModel.setBooleanState(false);
    }

    public Widget getHeader() {
        return this.header;
    }

    public Widget getMinimizeButton() {
        return this.minimizeWidget;
    }

    public Widget getPinsSeparator() {
        return this.pinsSeparator;
    }

    private final class ToggleMinimizedAction
    extends WidgetAction.Adapter {
        private ToggleMinimizedAction() {
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            if (event.getButton() == 1 || event.getButton() == 2) {
                VMDNodeWidget.this.stateModel.toggleBooleanState();
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }
    }
}

