/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class LevelOfDetailsWidget
extends Widget {
    private double hardMinimalZoom;
    private double softMinimalZoom;
    private double softMaximalZoom;
    private double hardMaximalZoom;

    public LevelOfDetailsWidget(Scene scene, double hardMinimalZoom, double softMinimalZoom, double softMaximalZoom, double hardMaximalZoom) {
        super(scene);
        this.hardMinimalZoom = hardMinimalZoom;
        this.softMinimalZoom = softMinimalZoom;
        this.softMaximalZoom = softMaximalZoom;
        this.hardMaximalZoom = hardMaximalZoom;
    }

    public void paintChildren() {
        double diff;
        double zoom = this.getScene().getZoomFactor();
        if (zoom <= this.hardMinimalZoom || zoom >= this.hardMaximalZoom) {
            return;
        }
        Graphics2D gr = this.getGraphics();
        Composite previousComposite = null;
        if (this.hardMinimalZoom < zoom && zoom < this.softMinimalZoom) {
            double diff2 = this.softMinimalZoom - this.hardMinimalZoom;
            if (diff2 > 0.0) {
                diff2 = (zoom - this.hardMinimalZoom) / diff2;
                previousComposite = gr.getComposite();
                gr.setComposite(AlphaComposite.getInstance(3, (float)diff2));
            }
        } else if (this.softMaximalZoom < zoom && zoom < this.hardMaximalZoom && (diff = this.hardMaximalZoom - this.softMaximalZoom) > 0.0) {
            diff = (this.hardMaximalZoom - zoom) / diff;
            previousComposite = gr.getComposite();
            gr.setComposite(AlphaComposite.getInstance(3, (float)diff));
        }
        super.paintChildren();
        if (previousComposite != null) {
            gr.setComposite(previousComposite);
        }
    }

    public boolean isHitAt(Point localLocation) {
        double zoom = this.getScene().getZoomFactor();
        if (zoom < this.hardMinimalZoom || zoom > this.hardMaximalZoom) {
            return false;
        }
        return super.isHitAt(localLocation);
    }
}

