/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<N, E> {
    private Collection<N> nodes;
    private Collection<Vertex> rootVertices;
    private Collection<Vertex> vertices;
    private Collection<E> edges;
    private Map<N, Vertex> vertexMap;
    private Map<E, Edge> edgeMap;
    private GraphScene scene;
    private UniversalGraph<N, E> uGraph;

    protected DirectedGraph(UniversalGraph<N, E> uGraph, GraphScene scene) {
        this.uGraph = uGraph;
        this.scene = scene;
        this.nodes = uGraph.getNodes();
        this.edges = uGraph.getEdges();
        this.vertexMap = new HashMap<N, Vertex>();
        this.edgeMap = new LinkedHashMap<E, Edge>();
        this.rootVertices = new ArrayList<Vertex>();
        this.vertices = new ArrayList<Vertex>();
    }

    public static <N, E> DirectedGraph createGraph(UniversalGraph<N, E> uGraph, GraphScene scene) {
        DirectedGraph<N, E> graph = new DirectedGraph<N, E>(uGraph, scene);
        graph.createGraph();
        return graph;
    }

    protected void createGraph() {
        for (E e : this.edges) {
            N source = this.uGraph.getEdgeSource(e);
            N target = this.uGraph.getEdgeTarget(e);
            Vertex sourceVertex = this.getVertex(source);
            Vertex targetVertex = this.getVertex(target);
            Edge edge = this.createEdge(sourceVertex, targetVertex, e);
            sourceVertex.addOutgoingEdge(edge);
            targetVertex.addIncomingEdge(edge);
            sourceVertex.addUpperNeighbor(targetVertex);
            targetVertex.addLowerNeighbor(sourceVertex);
        }
        for (Object node : this.nodes) {
            Vertex vertex = this.getVertex(node);
            Widget widget = this.scene.findWidget(node);
            if (widget == null) continue;
            Rectangle bounds = widget.getBounds();
            Dimension size = new Dimension(bounds.width, bounds.height);
            vertex.setSize(size);
        }
        this.findRootVertices();
    }

    private Vertex getVertex(N node) {
        Vertex vertex = this.vertexMap.get(node);
        if (vertex == null) {
            vertex = this.createVertex(node);
            this.vertexMap.put(node, vertex);
        }
        return vertex;
    }

    protected Vertex createVertex(N node) {
        return new Vertex<N>(node);
    }

    protected Edge createEdge(Vertex source, Vertex target, E edgeDE) {
        return new Edge<E>(source, target, edgeDE);
    }

    private Edge getEdge(Vertex source, Vertex target, E edgeDE) {
        Edge edge = this.edgeMap.get(edgeDE);
        if (edge == null) {
            edge = this.createEdge(source, target, edgeDE);
            this.edgeMap.put(edgeDE, edge);
        }
        return edge;
    }

    public Collection<Vertex> getVertices() {
        return this.vertexMap.values();
    }

    public Collection<Vertex> getRootVertices() {
        return this.rootVertices;
    }

    private void findRootVertices() {
        for (Vertex vertex : this.vertexMap.values()) {
            Collection<Vertex> uppers = vertex.getUpperNeighbors();
            if (uppers.size() != 0) continue;
            this.rootVertices.add(vertex);
        }
    }

    public DummyVertex insertDummyVertex(Edge edge, DummyVertex.Type type) {
        Edge originalEdge = edge;
        if (edge instanceof DummyEdge) {
            originalEdge = ((DummyEdge)edge).getOriginalEdge();
        }
        DummyVertex dv = this.createDummyVertex(originalEdge, type);
        this.vertices.add(dv);
        Vertex source = edge.getSource();
        Vertex target = edge.getTarget();
        source.removeOutgoingEdge(edge);
        source.removeLowerNeighbor(target);
        source.addLowerNeighbor(dv);
        dv.addUpperNeighbor(target);
        DummyEdge de = this.createDummyEdge(source, dv, originalEdge);
        source.addOutgoingEdge(de);
        dv.addIncomingEdge(de);
        target.removeIncomingEdge(edge);
        target.removeUpperNeighbor(source);
        target.addUpperNeighbor(dv);
        dv.addLowerNeighbor(target);
        de = this.createDummyEdge(dv, target, originalEdge);
        target.addIncomingEdge(de);
        dv.addOutgoingEdge(de);
        return dv;
    }

    protected DummyVertex createDummyVertex(Edge originalEdge, DummyVertex.Type type) {
        return new DummyVertex(originalEdge, type);
    }

    public DummyEdge addDummyEdge(Vertex source, Vertex target) {
        DummyEdge de = this.createDummyEdge(source, target, null);
        source.addOutgoingEdge(de);
        target.addIncomingEdge(de);
        source.addLowerNeighbor(target);
        target.addUpperNeighbor(source);
        return de;
    }

    protected DummyEdge createDummyEdge(Vertex source, Vertex target, Edge originalEdge) {
        return new DummyEdge(source, target, originalEdge);
    }

    private void printGraph() {
        for (Vertex rootVertex : this.getRootVertices()) {
            System.out.println("root vertex = " + rootVertex);
        }
        for (Vertex v : this.getVertices()) {
            System.out.println("vertex = " + v);
            Collection<Vertex> neighbors = v.getUpperNeighbors();
            for (Vertex nv : neighbors) {
                System.out.println("\tupper neighbor = " + nv);
            }
            neighbors = v.getLowerNeighbors();
            for (Vertex nv : neighbors) {
                System.out.println("\tlower neighbor = " + nv);
            }
        }
    }

    public static class DummyEdge
    extends Edge {
        private Edge originalEdge;

        public DummyEdge(Vertex source, Vertex target, Edge originalEdge) {
            super(source, target, null);
            this.originalEdge = originalEdge;
        }

        public DummyEdge(Vertex source, Vertex target) {
            this(source, target, null);
        }

        public void setOriginalEdge(Edge originalEdge) {
            this.originalEdge = originalEdge;
        }

        public Edge getOriginalEdge() {
            return this.originalEdge;
        }

        public String toString() {
            return "dummy " + super.toString();
        }
    }

    public static class DummyVertex
    extends Vertex {
        private static int counter = 0;
        private Edge originalEdge;
        private Type type;
        private int index;

        public DummyVertex(Edge originalEdge, Type type) {
            super(null);
            this.originalEdge = originalEdge;
            this.type = type;
            this.index = --counter;
        }

        public DummyVertex(Type type) {
            this(null, type);
        }

        public void setOriginalEdge(Edge originalEdge) {
            this.originalEdge = originalEdge;
        }

        public Edge getOriginalEdge() {
            return this.originalEdge;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "dummy vertex " + this.index;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CROSSING,
            HYPEREDGE,
            BEND,
            TEMPORARY;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Edge<E> {
        private Vertex source;
        private Vertex target;
        private E edgeDE;

        public Edge(Vertex source, Vertex target, E edgeDE) {
            this.source = source;
            this.target = target;
            this.edgeDE = edgeDE;
        }

        public Vertex getSource() {
            return this.source;
        }

        public Vertex getTarget() {
            return this.target;
        }

        public E getEdgeDesignElement() {
            return this.edgeDE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Vertex<N> {
        private N nodeDE;
        private ArrayList<Vertex> upperNeighbors;
        private ArrayList<Vertex> lowerNeighbors;
        private Collection<Edge> incomingEdges;
        private Collection<Edge> outgoingEdges;
        private int number = -1;
        private int x;
        private int y;
        private Object vertexData;
        private Dimension size = new Dimension(0, 0);

        public Vertex(N nodeDE) {
            this.nodeDE = nodeDE;
            this.upperNeighbors = new ArrayList();
            this.lowerNeighbors = new ArrayList();
            this.incomingEdges = new ArrayList<Edge>();
            this.outgoingEdges = new ArrayList<Edge>();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dim) {
            this.size = dim;
        }

        public N getNodeDesignElement() {
            return this.nodeDE;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void addLowerNeighbor(Vertex vertex) {
            if (!this.lowerNeighbors.contains(vertex)) {
                this.lowerNeighbors.add(vertex);
            }
        }

        public void removeLowerNeighbor(Vertex vertex) {
            this.lowerNeighbors.remove(vertex);
        }

        public void replaceLowerNeighbor(Vertex oldVertex, Vertex newVertex) {
            this.lowerNeighbors.set(this.lowerNeighbors.indexOf(oldVertex), newVertex);
        }

        public Collection<Vertex> getLowerNeighbors() {
            return Collections.unmodifiableCollection(this.lowerNeighbors);
        }

        public void addUpperNeighbor(Vertex vertex) {
            if (!this.upperNeighbors.contains(vertex)) {
                this.upperNeighbors.add(vertex);
            }
        }

        public void removeUpperNeighbor(Vertex vertex) {
            this.upperNeighbors.remove(vertex);
        }

        public void replaceUpperNeighbor(Vertex oldVertex, Vertex newVertex) {
            this.upperNeighbors.set(this.upperNeighbors.indexOf(oldVertex), newVertex);
        }

        public Collection<Vertex> getUpperNeighbors() {
            return Collections.unmodifiableCollection(this.upperNeighbors);
        }

        public Collection<Edge> getOutgoingEdges() {
            return this.outgoingEdges;
        }

        public void addOutgoingEdge(Edge edge) {
            if (!this.outgoingEdges.contains(edge)) {
                this.outgoingEdges.add(edge);
            }
        }

        public Collection<Edge> getIncomingEdges() {
            return this.incomingEdges;
        }

        public void removeOutgoingEdge(Edge edge) {
            this.outgoingEdges.remove(edge);
        }

        public void addIncomingEdge(Edge edge) {
            if (!this.incomingEdges.contains(edge)) {
                this.incomingEdges.add(edge);
            }
        }

        public void removeIncomingEdge(Edge edge) {
            this.incomingEdges.remove(edge);
        }

        public Edge getEdgeToLowerNeighbor(Vertex nv) {
            Collection<Edge> edges = nv.getOutgoingEdges();
            for (Edge edge : edges) {
                if (edge.getTarget() != nv) continue;
                return edge;
            }
            return this.getEdgeToUpperNeighbor(nv);
        }

        public Edge getEdgeToUpperNeighbor(Vertex nv) {
            Collection<Edge> edges = nv.getIncomingEdges();
            for (Edge edge : edges) {
                if (edge.getSource() != nv) continue;
                return edge;
            }
            return this.getEdgeToLowerNeighbor(nv);
        }

        public void setVertexData(Object data) {
            this.vertexData = data;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return super.toString() + " : " + this.nodeDE;
        }
    }
}

