/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap<Lookup.Template<?>, Reference<ProxyResult<?>>> results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup l = this.provider.getLookup();
        Iterator<Reference<ProxyResult<?>>> toCheck = null;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (l != this.delegate) {
                this.delegate = l;
                if (this.results != null) {
                    toCheck = new ArrayList(this.results.values()).iterator();
                }
            }
        }
        if (toCheck != null) {
            ArrayList<Object> evAndListeners = new ArrayList<Object>();
            Iterator<Reference<ProxyResult<Object>>> it = toCheck;
            while (it.hasNext()) {
                ProxyResult<?> p;
                Reference<ProxyResult<?>> ref = it.next();
                if (ref == null || (p = ref.get()) == null || !p.updateLookup(l)) continue;
                p.collectFires(evAndListeners);
            }
            it = evAndListeners.iterator();
            while (it.hasNext()) {
                LookupEvent ev = (LookupEvent)((Object)it.next());
                LookupListener ll = (LookupListener)((Object)it.next());
                ll.resultChanged(ev);
            }
        }
        return this.delegate;
    }

    private static <T> ProxyResult<T> cast(ProxyResult<?> p) {
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult<?> p;
                Reference<ProxyResult<?>> ref = this.results.get(template);
                if (ref != null && (p = ref.get()) != null) {
                    return SimpleProxyLookup.cast(p);
                }
            }
            ProxyResult<T> p = new ProxyResult<T>(template);
            WeakReference<ProxyResult<T>> ref = new WeakReference<ProxyResult<T>>(p);
            this.results.put(template, ref);
            return p;
        }
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (clazz == null) {
            this.checkLookup();
            return null;
        }
        return this.checkLookup().lookup(clazz);
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        return this.checkLookup().lookupItem(template);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result source;
        private Reference<ProxyResult<T>> result;

        public WeakResult(ProxyResult<T> r, Lookup.Result<T> s) {
            this.result = new WeakReference<ProxyResult<ProxyResult<T>>>(r);
            this.source = s;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            ProxyResult<T> r = this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            ProxyResult<T> r = this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            ProxyResult<T> r = this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProxyResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Template<T> template;
        private Lookup.Result<T> delegate;
        private EventListenerList listeners;
        private LookupListener lastListener;

        ProxyResult(Lookup.Template<T> template) {
            this.template = template;
        }

        private Lookup.Result<T> checkResult() {
            this.updateLookup(SimpleProxyLookup.this.checkLookup());
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup l) {
            LookupListener removedListener;
            Collection<Lookup.Item<T>> oldPairs = this.delegate != null ? this.delegate.allItems() : null;
            ProxyResult proxyResult = this;
            synchronized (proxyResult) {
                if (this.delegate != null && this.lastListener != null) {
                    removedListener = this.lastListener;
                    this.delegate.removeLookupListener(this.lastListener);
                } else {
                    removedListener = null;
                }
            }
            Lookup.Result<T> res = l.lookup(this.template);
            ProxyResult proxyResult2 = this;
            synchronized (proxyResult2) {
                if (removedListener == this.lastListener) {
                    this.delegate = res;
                    this.lastListener = new WeakResult<T>(this, this.delegate);
                    this.delegate.addLookupListener(this.lastListener);
                }
            }
            if (oldPairs == null) {
                return false;
            }
            Collection<Lookup.Item<T>> newPairs = this.delegate.allItems();
            if (!(oldPairs instanceof List)) {
                oldPairs = oldPairs == Collections.EMPTY_SET ? Collections.emptyList() : new ArrayList<Lookup.Item<T>>(oldPairs);
            }
            if (!(newPairs instanceof List)) {
                newPairs = new ArrayList<Lookup.Item<T>>(newPairs);
            }
            return !((Object)oldPairs).equals(newPairs);
        }

        @Override
        public synchronized void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(LookupListener.class, l);
        }

        @Override
        public synchronized void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, l);
            }
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.checkResult().allInstances();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return this.checkResult().allClasses();
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.checkResult().allItems();
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            Lookup.Result<T> r = this.checkResult();
            if (r instanceof WaitableResult) {
                ((WaitableResult)r).beforeLookup(t);
            }
        }

        @Override
        public void resultChanged(LookupEvent anEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            EventListenerList l = this.listeners;
            if (l == null) {
                return;
            }
            Object[] listeners = l.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(listeners, ev, evAndListeners);
        }
    }
}

