/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;

public class RolloverFileOutputStream
extends FilterOutputStream {
    static Log log = LogFactory.getLog(RolloverFileOutputStream.class);
    static Rollover __rollover;
    static final String YYYY_MM_DD = "yyyy_mm_dd";
    static final ArrayList __rollovers;
    private SimpleDateFormat _fileBackupFormat = new SimpleDateFormat(System.getProperty("ROLLOVERFILE_BACKUP_FORMAT", "HHmmssSSS"));
    private SimpleDateFormat _fileDateFormat = new SimpleDateFormat(System.getProperty("ROLLOVERFILE_DATE_FORMAT", "yyyy_MM_dd"));
    private String _filename;
    private File _file;
    private boolean _append;
    private int _retainDays;
    private WeakReference _ref;

    static {
        __rollovers = new ArrayList();
    }

    public RolloverFileOutputStream(String filename) throws IOException {
        this(filename, true, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    public RolloverFileOutputStream(String filename, boolean append) throws IOException {
        this(filename, append, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RolloverFileOutputStream(String filename, boolean append, int retainDays) throws IOException {
        super(null);
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        if (filename == null) {
            throw new IllegalArgumentException("Invalid filename");
        }
        this._filename = filename;
        this._append = append;
        this._retainDays = retainDays;
        this._ref = new WeakReference<RolloverFileOutputStream>(this);
        this.setFile();
        ArrayList arrayList = __rollovers;
        synchronized (arrayList) {
            if (__rollover == null) {
                __rollover = new Rollover();
                __rollover.start();
            }
            __rollovers.add(this._ref);
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._file == null) {
            return null;
        }
        return this._file.toString();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    private synchronized void setFile() throws IOException {
        File file = new File(this._filename);
        this._filename = file.getCanonicalPath();
        file = new File(this._filename);
        File dir2 = new File(file.getParent());
        if (!dir2.isDirectory() || !dir2.canWrite()) {
            throw new IOException("Cannot write log directory " + dir2);
        }
        Date now = new Date();
        String filename = file.getName();
        int i = filename.toLowerCase().indexOf(YYYY_MM_DD);
        if (i >= 0) {
            file = new File(dir2, String.valueOf(filename.substring(0, i)) + this._fileDateFormat.format(now) + filename.substring(i + YYYY_MM_DD.length()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Cannot write log file " + file);
        }
        if (this.out == null || !file.equals(this._file)) {
            this._file = file;
            if (!this._append && file.exists()) {
                file.renameTo(new File(String.valueOf(file.toString()) + "." + this._fileBackupFormat.format(now)));
            }
            OutputStream oldOut = this.out;
            this.out = new FileOutputStream(file.toString(), this._append);
            if (oldOut != null) {
                oldOut.close();
            }
            if (log.isDebugEnabled()) {
                log.debug("Opened " + this._file);
            }
        }
    }

    private void removeOldFiles() {
        if (this._retainDays > 0) {
            Calendar retainDate = Calendar.getInstance();
            retainDate.add(5, -this._retainDays);
            int borderYear = retainDate.get(1);
            int borderMonth = retainDate.get(2) + 1;
            int borderDay = retainDate.get(5);
            File file = new File(this._filename);
            File dir2 = new File(file.getParent());
            String fn = file.getName();
            int s = fn.toLowerCase().indexOf(YYYY_MM_DD);
            if (s < 0) {
                return;
            }
            String prefix = fn.substring(0, s);
            String suffix = fn.substring(s + YYYY_MM_DD.length());
            String[] logList = dir2.list();
            int i = 0;
            while (i < logList.length) {
                block7: {
                    fn = logList[i];
                    if (fn.startsWith(prefix) && fn.indexOf(suffix, prefix.length()) >= 0) {
                        try {
                            StringTokenizer st = new StringTokenizer(fn.substring(prefix.length(), prefix.length() + YYYY_MM_DD.length()), "_.");
                            int nYear = Integer.parseInt(st.nextToken());
                            int nMonth = Integer.parseInt(st.nextToken());
                            int nDay = Integer.parseInt(st.nextToken());
                            if (nYear < borderYear || nYear == borderYear && nMonth < borderMonth || nYear == borderYear && nMonth == borderMonth && nDay <= borderDay) {
                                log.info("Log age " + fn);
                                new File(dir2, fn).delete();
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block7;
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList arrayList = __rollovers;
        synchronized (arrayList) {
            __rollovers.remove(this._ref);
            this._ref = null;
            try {
                super.close();
            }
            finally {
                this.out = null;
                this._file = null;
            }
            if (__rollovers.size() == 0) {
                __rollover.timeToStop();
                __rollover.interrupt();
                __rollover = null;
            }
        }
    }

    private class Rollover
    extends Thread {
        private volatile boolean timeToStop = false;

        Rollover() {
            this.setName("Rollover");
            this.setDaemon(true);
        }

        synchronized void timeToStop() {
            this.timeToStop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.timeToStop) {
                block11: {
                    try {
                        Calendar now = Calendar.getInstance();
                        GregorianCalendar midnight = new GregorianCalendar(now.get(1), now.get(2), now.get(5), 23, 0);
                        midnight.add(10, 1);
                        long sleeptime = midnight.getTime().getTime() - now.getTime().getTime();
                        if (log.isDebugEnabled()) {
                            log.debug("Rollover sleep until " + midnight.getTime());
                        }
                        Thread.sleep(sleeptime);
                    }
                    catch (InterruptedException e) {
                        if (this.timeToStop) break block11;
                        e.printStackTrace();
                    }
                }
                ArrayList arrayList = __rollovers;
                synchronized (arrayList) {
                    ListIterator iter = __rollovers.listIterator();
                    while (iter.hasNext()) {
                        WeakReference ref = (WeakReference)iter.next();
                        RolloverFileOutputStream rfos = (RolloverFileOutputStream)ref.get();
                        if (rfos == null) {
                            iter.remove();
                            continue;
                        }
                        try {
                            rfos.setFile();
                            rfos.removeOldFiles();
                        }
                        catch (IOException e) {
                            if (this.timeToStop) continue;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

