/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Stack;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class FileSystemCopier
implements ICVSResourceVisitor {
    public static final String CVS_DIRNAME = "CVS";
    public static final String REPOSITORY = "Repository";
    public static final String ROOT = "Root";
    public static final String STATIC = "Entries.Static";
    public static final String TAG = "Tag";
    public static final String ENTRIES = "Entries";
    private final IPath fsRoot;
    private final ICVSFolder cvsRoot;
    private final IProgressMonitor monitor;
    private final Stack<FolderInfo> currentPath = new Stack();

    private static IPath createDirectory(IPath parentFolder) throws CVSException {
        File dir = parentFolder.toFile();
        if (!dir.mkdirs() && !dir.exists()) {
            throw new CVSException(NLS.bind((String)Messages.unable_to_create_directory_0, (Object)dir));
        }
        return parentFolder;
    }

    private static void writeLines(IPath parentFolder, String metaFile, String ... lines) throws CVSException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(parentFolder.append(metaFile).toFile());
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    out.println(line);
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }

    public FileSystemCopier(ICVSFolder cvsRoot, IPath fsRoot, IProgressMonitor monitor) throws CVSException {
        this.cvsRoot = cvsRoot;
        this.fsRoot = fsRoot;
        this.monitor = monitor;
        this.monitor.beginTask(null, -1);
    }

    public void done() throws CVSException {
        while (!this.currentPath.isEmpty()) {
            this.visitFolderEnd();
        }
        this.monitor.done();
    }

    public void visitFile(ICVSFile file) throws CVSException {
        this.checkFolderEnd(file.getParent());
        FolderInfo fi = this.currentPath.peek();
        fi.assertCreated();
        FileOutputStream out = null;
        InputStream in = null;
        File osFile = fi.getPath().append(file.getName()).toFile();
        try {
            try {
                out = new FileOutputStream(osFile);
                in = file.getContents();
                FileUtils.copyFile((InputStream)in, (OutputStream)out, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)this.monitor, (int)10));
            }
            catch (IOException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            IOUtils.close((Closeable)out);
            throw throwable;
        }
        IOUtils.close((Closeable)in);
        IOUtils.close((Closeable)out);
        ResourceSyncInfo syncInfo = file.getSyncInfo();
        Date timestamp = syncInfo.getTimeStamp();
        if (timestamp != null) {
            osFile.setLastModified(timestamp.getTime());
        } else {
            MutableResourceSyncInfo mrsi = syncInfo.cloneMutable();
            mrsi.setTimeStamp(new Date(osFile.lastModified()));
            syncInfo = mrsi;
        }
        fi.addEntry(syncInfo.getBytes());
    }

    public void visitFolder(ICVSFolder folder) throws CVSException {
        this.checkFolderEnd(folder);
        this.currentPath.push(new FolderInfo(folder, this.fsRoot.append(folder.getRelativePath(this.cvsRoot))));
    }

    private void checkFolderEnd(ICVSFolder folder) throws CVSException {
        if (!this.currentPath.isEmpty()) {
            IPath fullPath = this.fsRoot.append(folder.getRelativePath(this.cvsRoot));
            while (!this.currentPath.peek().isPrefixOf(fullPath)) {
                this.visitFolderEnd();
            }
        }
    }

    private void visitFolderEnd() throws CVSException {
        FolderInfo info = this.currentPath.pop();
        if (info.isEmpty()) {
            return;
        }
        info.writeSync();
        MonitorUtils.worked((IProgressMonitor)this.monitor, (int)5);
        if (!this.currentPath.isEmpty()) {
            this.currentPath.peek().addEntry(info.getFolderSyncBytes());
        }
    }

    private static class FolderInfo {
        private final IPath path;
        private final ArrayList<byte[]> entries;
        private final ICVSFolder folder;
        private boolean isCreated;

        FolderInfo(ICVSFolder folder, IPath path) throws CVSException {
            this.folder = folder;
            this.entries = new ArrayList();
            this.path = path;
        }

        void addEntry(byte[] entry) {
            this.entries.add(entry);
        }

        void assertCreated() throws CVSException {
            if (!this.isCreated) {
                FileSystemCopier.createDirectory(this.path);
                this.isCreated = true;
            }
        }

        byte[] getFolderSyncBytes() throws CVSException {
            return this.folder.getSyncInfo().getBytes();
        }

        IPath getPath() {
            return this.path;
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        boolean isPrefixOf(IPath test) {
            return this.path.isPrefixOf(test);
        }

        void writeSync() throws CVSException {
            this.assertCreated();
            IPath cvsFolder = FileSystemCopier.createDirectory(this.path.append(FileSystemCopier.CVS_DIRNAME));
            int idx = this.entries.size();
            String[] entryArray = new String[idx];
            while (--idx >= 0) {
                entryArray[idx] = new String(this.entries.get(idx));
            }
            FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.ENTRIES, entryArray);
            FolderSyncInfo info = this.folder.getFolderSyncInfo();
            FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.ROOT, new String[]{info.getRoot()});
            FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.REPOSITORY, new String[]{info.getRepository()});
            if (info.getTag() != null) {
                FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.TAG, new String[]{info.getTag().toEntryLineFormat(false)});
            }
            if (info.getIsStatic()) {
                FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.STATIC, new String[]{""});
            }
        }
    }
}

