/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.ui.providers;

import org.eclipse.buckminster.generic.model.tree.ITreeDataListener;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeRootNode;
import org.eclipse.buckminster.generic.model.tree.TreeDataEvent;
import org.eclipse.buckminster.generic.ui.Messages;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class TreeDataNodeContentProvider
implements IStructuredContentProvider,
ITreeContentProvider,
ITreeDataListener {
    private ITreeRootNode invisibleRoot;
    private TreeViewer treeViewer;

    public void dispose() {
        this.invisibleRoot.removeTreeDataListener((ITreeDataListener)this);
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ITreeParentDataNode) {
            return ((ITreeParentDataNode)parent).getChildren();
        }
        return new Object[0];
    }

    public Object[] getElements(Object parent) {
        if (!(parent instanceof ITreeDataNode)) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof ITreeDataNode) {
            return ((ITreeDataNode)child).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ITreeParentDataNode) {
            return ((ITreeParentDataNode)parent).hasChildren();
        }
        return false;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (!(v instanceof TreeViewer)) {
            throw new IllegalArgumentException(Messages.only_TreeView_accepted);
        }
        this.treeViewer = (TreeViewer)v;
    }

    public void treeNodeChanged(TreeDataEvent event) {
        switch (event.getType()) {
            case CHANGE: {
                if (event.getNode() instanceof ITreeRootNode) {
                    this.treeViewer.refresh();
                    break;
                }
                this.treeViewer.refresh((Object)event.getNode());
            }
        }
    }

    protected ITreeParentDataNode getHiddenRoot() {
        return this.invisibleRoot;
    }

    protected abstract void initialize();

    protected void setHiddenRoot(ITreeRootNode hiddenRoot) {
        if (this.invisibleRoot != null) {
            this.invisibleRoot.removeTreeDataListener((ITreeDataListener)this);
        }
        this.invisibleRoot = hiddenRoot;
        this.invisibleRoot.addTreeDataListener((ITreeDataListener)this);
    }
}

