/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.git.internal.Messages;
import org.eclipse.buckminster.git.internal.RepositoryAccess;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitReader
extends AbstractCatalogReader {
    private final RepositoryAccess repoAccess;

    protected GitReader(IReaderType readerType, ProviderMatch providerMatch) throws CoreException {
        super(readerType, providerMatch);
        Provider provider = providerMatch.getProvider();
        Map props = provider.getProperties(providerMatch.getNodeQuery().getProperties());
        this.repoAccess = new RepositoryAccess(provider.getURI(props), props);
    }

    public File getLocation() throws CoreException {
        return this.repoAccess.getLocation(this.getProviderMatch().getVersionMatch());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        String string = this.repoAccess.getRepositoryPath();
        synchronized (string) {
            try (TreeWalk walk = this.repoAccess.getTreeWalk(this.getProviderMatch().getVersionMatch(), fileName, monitor);){
                boolean bl = walk.next();
                return bl;
            }
        }
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        File location = this.getLocation();
        try {
            location = location.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File destFile = destination.toFile();
        try {
            destFile = destFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!location.equals(destFile)) {
            throw new UnsupportedOperationException(Messages.git_reader_can_not_materialize);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        String string = this.repoAccess.getRepositoryPath();
        synchronized (string) {
            VersionMatch vm = this.getProviderMatch().getVersionMatch();
            TreeWalk walk = this.repoAccess.getTreeWalk(vm, fileName, monitor);
            if (!walk.next()) {
                throw new FileNotFoundException(fileName);
            }
            Repository repo = this.repoAccess.getRepository(vm, monitor);
            ObjectLoader ol = repo.open((AnyObjectId)walk.getObjectId(0));
            byte[] bytes = ol.getBytes();
            Object object = consumer.consumeStream((IComponentReader)this, fileName, (InputStream)new ByteArrayInputStream(bytes), monitor);
            return (T)object;
            finally {
                walk.close();
            }
        }
    }

    public boolean isFileSystemReader() {
        return true;
    }
}

