/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.Map;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.ComponentIdentifier;
import org.eclipse.buckminster.model.common.ComponentName;
import org.eclipse.buckminster.model.common.impl.ComponentNameImpl;
import org.eclipse.buckminster.model.common.util.VersionHelper;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.equinox.p2.metadata.Version;

public class ComponentIdentifierImpl
extends ComponentNameImpl
implements ComponentIdentifier {
    protected static final Version VERSION_EDEFAULT = null;
    protected Version version = VERSION_EDEFAULT;

    protected ComponentIdentifierImpl() {
    }

    @Override
    public int compareTo(ComponentName o) {
        if (this == o) {
            return 0;
        }
        int cmp = super.compareTo(o);
        if (cmp == 0) {
            cmp = Trivial.compareAllowNull((Comparable)this.getVersion(), o instanceof ComponentIdentifier ? ((ComponentIdentifier)o).getVersion() : null);
        }
        return cmp;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getVersion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || super.equals(o) && Trivial.equalsAllowNull((Object)this.getVersion(), (Object)((ComponentIdentifier)o).getVersion());
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setVersion((Version)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.getVersion() != null) {
            p.put("buckminster.version", this.getVersion().toString());
        }
        return p;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc *= 37;
        if (this.version != null) {
            hc += this.version.hashCode();
        }
        return hc;
    }

    @Override
    public boolean matches(ComponentIdentifier ci) {
        return super.matches(ci) && (this.getVersion() == null || ci.getVersion() == null || this.getVersion().equals(ci.getVersion()));
    }

    @Override
    public void setVersion(Version newVersion) {
        Version oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public ComponentName toPureComponentName() {
        ComponentNameImpl cn = new ComponentNameImpl();
        cn.setId(this.getId());
        cn.setType(this.getType());
        return cn;
    }

    @Override
    public void toString(StringBuilder result) {
        super.toString(result);
        result.append('$');
        if (this.getVersion() != null) {
            result.append(VersionHelper.getHumanReadable(this.getVersion()));
        }
    }

    public String toStringGen() {
        return null;
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.COMPONENT_IDENTIFIER;
    }
}

