/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.Match;
import org.eclipse.buckminster.model.common.Replace;
import org.eclipse.buckminster.model.common.impl.ValueFilterImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ReplaceImpl
extends ValueFilterImpl
implements Replace {
    protected EList<Match> matches;
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    protected static final boolean QUOTE_PATTERN_EDEFAULT = false;
    protected boolean quotePattern = false;
    protected boolean quotePatternESet;
    protected static final String REPLACEMENT_EDEFAULT = null;
    protected String replacement = REPLACEMENT_EDEFAULT;
    protected static final Pattern COMPILED_PATTERN_EDEFAULT = null;
    protected Pattern compiledPattern = COMPILED_PATTERN_EDEFAULT;

    protected ReplaceImpl() {
    }

    @Override
    public String checkedGetValue(Map<String, String> props, int recursionGuard) {
        String resolved;
        block3: {
            EList<Match> ms;
            block2: {
                String result;
                resolved = this.checkedGetSourceValue(props, recursionGuard);
                if (resolved == null || "".equals(resolved)) {
                    return "";
                }
                ms = this.getMatches();
                if (ms.size() != 0) break block2;
                Match match = this.getSelfMatch();
                if (match == null || (result = match.match(resolved)) == null) break block3;
                resolved = result;
                break block3;
            }
            for (Match match : ms) {
                String result = match.match(resolved);
                if (result == null) continue;
                resolved = result;
                break;
            }
        }
        return resolved;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getMatches();
            }
            case 4: {
                return this.getPattern();
            }
            case 5: {
                return this.isQuotePattern();
            }
            case 6: {
                return this.getReplacement();
            }
            case 7: {
                return this.getCompiledPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getMatches()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.matches != null && !this.matches.isEmpty();
            }
            case 4: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 5: {
                return this.isSetQuotePattern();
            }
            case 6: {
                return REPLACEMENT_EDEFAULT == null ? this.replacement != null : !REPLACEMENT_EDEFAULT.equals(this.replacement);
            }
            case 7: {
                return COMPILED_PATTERN_EDEFAULT == null ? this.compiledPattern != null : !COMPILED_PATTERN_EDEFAULT.equals(this.compiledPattern);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getMatches().clear();
                this.getMatches().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setPattern((String)newValue);
                return;
            }
            case 5: {
                this.setQuotePattern((Boolean)newValue);
                return;
            }
            case 6: {
                this.setReplacement((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getMatches().clear();
                return;
            }
            case 4: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 5: {
                this.unsetQuotePattern();
                return;
            }
            case 6: {
                this.setReplacement(REPLACEMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public synchronized Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            String tmp = this.getPattern();
            if (tmp == null) {
                return null;
            }
            if (this.isQuotePattern()) {
                tmp = Pattern.quote(tmp);
            }
            this.compiledPattern = Pattern.compile(tmp);
        }
        return this.compiledPattern;
    }

    @Override
    public EList<Match> getMatches() {
        if (this.matches == null) {
            this.matches = new EObjectContainmentEList(Match.class, (InternalEObject)this, 3);
        }
        return this.matches;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public boolean isQuotePattern() {
        return this.quotePattern;
    }

    @Override
    public boolean isSetQuotePattern() {
        return this.quotePatternESet;
    }

    @Override
    public synchronized void setPattern(String newPattern) {
        this.setPatternGen(newPattern);
        this.compiledPattern = null;
    }

    public void setPatternGen(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public synchronized void setQuotePattern(boolean newQuotePattern) {
        this.setQuotePatternGen(newQuotePattern);
        this.compiledPattern = null;
    }

    public void setQuotePatternGen(boolean newQuotePattern) {
        boolean oldQuotePattern = this.quotePattern;
        this.quotePattern = newQuotePattern;
        boolean oldQuotePatternESet = this.quotePatternESet;
        this.quotePatternESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldQuotePattern, this.quotePattern, !oldQuotePatternESet));
        }
    }

    @Override
    public void setReplacement(String newReplacement) {
        String oldReplacement = this.replacement;
        this.replacement = newReplacement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldReplacement, (Object)this.replacement));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(", quotePattern: ");
        if (this.quotePatternESet) {
            result.append(this.quotePattern);
        } else {
            result.append("<unset>");
        }
        result.append(", replacement: ");
        result.append(this.replacement);
        result.append(", compiledPattern: ");
        result.append(this.compiledPattern);
        result.append(')');
        return result.toString();
    }

    @Override
    public void unsetQuotePattern() {
        boolean oldQuotePattern = this.quotePattern;
        boolean oldQuotePatternESet = this.quotePatternESet;
        this.quotePattern = false;
        this.quotePatternESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, oldQuotePattern, false, oldQuotePatternESet));
        }
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.REPLACE;
    }

    private Match getSelfMatch() {
        Match match = CommonFactory.eINSTANCE.createMatch();
        match.setPattern(this.getPattern());
        match.setQuotePattern(this.isQuotePattern());
        match.setReplacement(this.getReplacement());
        return match;
    }
}

