/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.RxAssembly;
import org.eclipse.buckminster.model.common.RxPart;
import org.eclipse.buckminster.model.common.impl.RxGroupImpl;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;

public class RxAssemblyImpl
extends RxGroupImpl
implements RxAssembly {
    protected static final Pattern PATTERN_EDEFAULT = null;
    protected Pattern pattern = PATTERN_EDEFAULT;
    private List<RxPart> parameters;

    protected RxAssemblyImpl() {
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Map<String, String> getMatchMap(CharSequence input) {
        if (input == null) {
            return null;
        }
        Logger logger = Buckminster.getLogger();
        this.getPattern();
        Matcher m = this.pattern.matcher(input);
        if (!m.matches()) {
            logger.debug("Pattern does not match %s", new Object[]{input});
            return null;
        }
        int groupCount = m.groupCount();
        int top = this.parameters.size();
        if (logger.isDebugEnabled()) {
            logger.debug("Pattern captured %d groups in %s", new Object[]{groupCount, input});
        }
        if (top != groupCount) {
            logger.warning(NLS.bind((String)"Pattern group count was {0}, expected {1}", (Object)groupCount, (Object)top), new Object[0]);
            top = groupCount;
        }
        if (top == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> matchMap = new HashMap<String, String>();
        int idx = 0;
        while (idx < top) {
            RxPart param = this.parameters.get(idx);
            String value = Trivial.trim((String)m.group(idx + 1));
            if (value != null) {
                logger.debug("Assigning pattern parameter %s=\"%s\"", new Object[]{param.getName(), value});
                matchMap.put(param.getName(), value);
            }
            ++idx;
        }
        return matchMap;
    }

    @Override
    public Pattern getPattern() {
        if (this.pattern == null) {
            StringBuilder bld = new StringBuilder();
            bld.append('^');
            this.parameters = new ArrayList<RxPart>();
            this.addChildrenPatterns(bld, this.parameters);
            bld.append('$');
            String patternStr = bld.toString();
            this.pattern = Pattern.compile(patternStr);
            Buckminster.getLogger().debug("URI pattern %s created", new Object[]{patternStr});
        }
        return this.pattern;
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(')');
        return result.toString();
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.RX_ASSEMBLY;
    }
}

