/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.RxPart;
import org.eclipse.buckminster.model.common.RxPattern;
import org.eclipse.buckminster.model.common.impl.RxPartImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class RxPatternImpl
extends RxPartImpl
implements RxPattern {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    protected static final String PREFIX_EDEFAULT = null;
    protected String prefix = PREFIX_EDEFAULT;
    protected static final String SUFFIX_EDEFAULT = null;
    protected String suffix = SUFFIX_EDEFAULT;

    private static void addEscapedPattern(StringBuilder bld, String pattern, boolean willBeGroup) {
        int orDepth = -1;
        int startPos = bld.length();
        int parenDepth = 0;
        boolean inCharGroup = false;
        boolean stripOuter = false;
        int top = pattern.length();
        int idx = 0;
        while (idx < top) {
            int c = pattern.charAt(idx++);
            switch (c) {
                case 92: {
                    bld.append((char)c);
                    if (idx >= top) break;
                    c = pattern.charAt(idx++);
                    break;
                }
                case 124: {
                    if (orDepth != -1 && orDepth <= parenDepth) break;
                    orDepth = parenDepth;
                    break;
                }
                case 91: {
                    inCharGroup = true;
                    break;
                }
                case 93: {
                    inCharGroup = false;
                    break;
                }
                case 40: {
                    if (inCharGroup) break;
                    ++parenDepth;
                    if (idx == top) break;
                    if (pattern.charAt(idx) != '?') {
                        if (idx == 1) {
                            stripOuter = true;
                        }
                        bld.append("(?");
                        c = 58;
                        break;
                    }
                    if (idx != 1 || top <= 2) break;
                    stripOuter = pattern.charAt(2) == ':';
                    break;
                }
                case 41: {
                    if (inCharGroup || --parenDepth < 0 || parenDepth != 0 || idx >= top) break;
                    stripOuter = false;
                }
            }
            bld.append((char)c);
        }
        if (parenDepth != 0) {
            throw new PatternSyntaxException("Unbalanced parenthesis", pattern, 0);
        }
        if (stripOuter) {
            if (willBeGroup || orDepth != 1) {
                int tpos = startPos;
                int fpos = startPos + 3;
                int epos = bld.length() - 1;
                while (fpos < epos) {
                    bld.setCharAt(tpos++, bld.charAt(fpos++));
                }
                bld.setLength(tpos);
            }
        } else if (!willBeGroup && orDepth == 0) {
            String subExpr = bld.substring(startPos, bld.length());
            bld.setLength(startPos);
            bld.append("(?:");
            bld.append(subExpr);
            bld.append(')');
        }
    }

    private static void addQuotedString(StringBuilder bld, String str) {
        int top = str.length();
        int idx = 0;
        while (idx < top) {
            char c = str.charAt(idx);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    bld.append('\\');
                }
            }
            bld.append(c);
            ++idx;
        }
    }

    protected RxPatternImpl() {
    }

    @Override
    public void addPattern(StringBuilder bld, List<RxPart> namedParts) {
        if (!this.isOptional()) {
            this.addInnerPattern(bld, namedParts, false);
            return;
        }
        bld.append('(');
        if (this.prefix == null && this.suffix == null) {
            if (this.name == null) {
                bld.append("?:");
            } else {
                namedParts.add(this);
            }
            if (this.pattern != null) {
                RxPatternImpl.addEscapedPattern(bld, this.pattern, true);
            }
        } else {
            bld.append("?:");
            this.addInnerPattern(bld, namedParts, true);
        }
        bld.append(")?");
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getPattern();
            }
            case 3: {
                return this.getPrefix();
            }
            case 4: {
                return this.getSuffix();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 3: {
                return PREFIX_EDEFAULT == null ? this.prefix != null : !PREFIX_EDEFAULT.equals(this.prefix);
            }
            case 4: {
                return SUFFIX_EDEFAULT == null ? this.suffix != null : !SUFFIX_EDEFAULT.equals(this.suffix);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setPattern((String)newValue);
                return;
            }
            case 3: {
                this.setPrefix((String)newValue);
                return;
            }
            case 4: {
                this.setSuffix((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 3: {
                this.setPrefix(PREFIX_EDEFAULT);
                return;
            }
            case 4: {
                this.setSuffix(SUFFIX_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setPattern(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public void setPrefix(String newPrefix) {
        String oldPrefix = this.prefix;
        this.prefix = newPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldPrefix, (Object)this.prefix));
        }
    }

    @Override
    public void setSuffix(String newSuffix) {
        String oldSuffix = this.suffix;
        this.suffix = newSuffix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSuffix, (Object)this.suffix));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(", prefix: ");
        result.append(this.prefix);
        result.append(", suffix: ");
        result.append(this.suffix);
        result.append(')');
        return result.toString();
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.RX_PATTERN;
    }

    private void addInnerPattern(StringBuilder bld, List<RxPart> namedParts, boolean willBeGroup) {
        if (this.prefix != null) {
            RxPatternImpl.addQuotedString(bld, this.prefix);
        }
        if (this.pattern != null) {
            if (this.getName() != null) {
                bld.append('(');
                RxPatternImpl.addEscapedPattern(bld, this.pattern, true);
                bld.append(')');
                namedParts.add(this);
            } else {
                RxPatternImpl.addEscapedPattern(bld, this.pattern, willBeGroup && this.prefix == null && this.suffix == null);
            }
        }
        if (this.suffix != null) {
            RxPatternImpl.addQuotedString(bld, this.suffix);
        }
    }
}

