/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.File;
import java.util.Properties;
import org.eclipse.buckminster.runtime.IFileInfo;

public class FileInfoBuilder
implements IFileInfo {
    private String contentType;
    private long lastModified = 0L;
    private String name;
    private long size = -1L;

    public FileInfoBuilder() {
    }

    public FileInfoBuilder(File localFile) {
        this.lastModified = localFile.lastModified();
        this.name = localFile.getAbsolutePath();
        this.size = localFile.length();
    }

    public FileInfoBuilder(IFileInfo fileInfo) {
        this.initFrom(fileInfo);
    }

    public FileInfoBuilder(Properties properties) {
        this.name = properties.getProperty("name");
        this.contentType = properties.getProperty("contentType");
        String v = properties.getProperty("lastModified");
        if (v != null) {
            this.lastModified = Long.parseLong(v);
        }
        if ((v = properties.getProperty("size")) != null) {
            this.size = Long.parseLong(v);
        }
    }

    public void addProperties(Properties properties) {
        if (this.contentType != null) {
            properties.setProperty("contentType", this.contentType);
        }
        if (this.lastModified != 0L) {
            properties.setProperty("lastModified", Long.toString(this.lastModified));
        }
        if (this.name != null) {
            properties.setProperty("name", this.name);
        }
        if (this.size != -1L) {
            properties.setProperty("size", Long.toString(this.size));
        }
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public final String getRemoteName() {
        return this.name;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    public void initFrom(IFileInfo info) {
        this.setName(info.getRemoteName());
        this.setContentType(info.getContentType());
        this.setSize(info.getSize());
        this.setLastModified(info.getLastModified());
    }

    public void reset() {
        this.name = null;
        this.contentType = null;
        this.size = -1L;
        this.lastModified = 0L;
    }

    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLastModified(long timestamp) {
        this.lastModified = timestamp;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setSize(long size) {
        this.size = size;
    }
}

