/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class IOUtils {
    private static HashSet<File> foldersToRemove;

    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void copy(InputStream in, OutputStream out, IProgressMonitor monitor) throws IOException {
        MonitorUtils.begin(monitor, -1);
        try {
            int len;
            byte[] buffer = new byte[2048];
            while ((len = in.read(buffer)) > 0) {
                MonitorUtils.worked(monitor, 1);
                out.write(buffer, 0, len);
            }
        }
        finally {
            MonitorUtils.done(monitor);
        }
    }

    public static final void copy(Reader in, Writer out, IProgressMonitor monitor) throws IOException {
        MonitorUtils.begin(monitor, -1);
        try {
            int len;
            char[] buffer = new char[1024];
            while ((len = in.read(buffer)) > 0) {
                MonitorUtils.worked(monitor, 1);
                out.write(buffer, 0, len);
            }
        }
        finally {
            MonitorUtils.done(monitor);
        }
    }

    public static synchronized void createTempFolder(File tmpDir) throws IOException {
        if (tmpDir.exists()) {
            throw new IOException("Path already exists: " + tmpDir.getAbsolutePath());
        }
        if (!tmpDir.mkdirs()) {
            throw new IOException("Unable to create directory: " + tmpDir.getAbsolutePath());
        }
        if (foldersToRemove == null) {
            foldersToRemove = new HashSet();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HashSet folders = new HashSet(foldersToRemove);
                    foldersToRemove = null;
                    for (File folder : folders) {
                        try {
                            IOUtils.deleteRecursive(folder, null);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to remove directory " + folder.getAbsolutePath() + " :" + e.toString());
                        }
                    }
                }
            });
        }
        foldersToRemove.add(tmpDir);
    }

    public static synchronized File createTempFolder(String prefix, String suffix, File directory) throws IOException {
        directory.mkdirs();
        File tmpFile = File.createTempFile(prefix, suffix, directory);
        if (!tmpFile.delete()) {
            throw new IOException("Unable to delete file: " + tmpFile.getAbsolutePath());
        }
        IOUtils.createTempFolder(tmpFile);
        return tmpFile;
    }

    public static void deleteRecursive(File file, IProgressMonitor monitor) throws IOException {
        MonitorUtils.begin(monitor, 1000);
        try {
            if (file == null) {
                return;
            }
            try {
                int count;
                File[] list = file.listFiles();
                int n = count = list == null ? 0 : list.length;
                if (count > 0) {
                    IProgressMonitor subMon = MonitorUtils.subMonitor(monitor, 900);
                    MonitorUtils.begin(subMon, count * 100);
                    try {
                        if (foldersToRemove != null) {
                            foldersToRemove.remove(file);
                        }
                        while (--count >= 0) {
                            IOUtils.deleteRecursive(list[count], MonitorUtils.subMonitor(subMon, 100));
                        }
                    }
                    finally {
                        MonitorUtils.done(subMon);
                    }
                } else {
                    MonitorUtils.worked(monitor, 900);
                }
                if (!file.delete() && file.exists()) {
                    throw new IOException("Unable to delete file: " + file.getAbsolutePath());
                }
                MonitorUtils.worked(monitor, 100);
            }
            catch (SecurityException e) {
                throw new IOException("Unable to delete file: " + file.getAbsolutePath(), e);
            }
        }
        finally {
            MonitorUtils.done(monitor);
        }
    }

    public static File getTempRoot(Map<String, String> properties) {
        String tempRootStr = properties.get("buckminster.temp.root");
        File tempRoot = tempRootStr == null ? new File(new File(System.getProperty("java.io.tmpdir")), "buckminster") : new File(tempRootStr);
        return tempRoot;
    }

    public static URI uri(String uriStr) {
        try {
            return uriStr == null ? null : new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert String into URI: " + uriStr);
        }
    }

    public static URI uri(URL url) {
        try {
            return url == null ? null : url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert URL into URI: " + url);
        }
    }

    public static URL url(File file) {
        return file == null ? null : IOUtils.url(file.toURI());
    }

    public static URL url(URI uri) {
        try {
            return uri == null ? null : uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to convert URI into URL: " + uri);
        }
    }
}

