/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.ui.AbstractCSpecAction;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.input.BOMEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenDepencencyGraphAction
extends AbstractCSpecAction {
    private static final Set<String> EMPTY_SET = new HashSet<String>(0);

    public void run(IAction action) {
        super.run(action);
    }

    private BOMNode buildBOM(Resolution resolution, Map<UUID, BOMNode> bomCache, SubMonitor monitor) throws CoreException {
        Collection children = resolution.getCSpec().getDependencies();
        monitor.beginTask(Messages.OpenDepencencyGraphAction_ProcessingGraphMainTaskLabel, 100 * children.size());
        String subtask = Messages.OpenDepencencyGraphAction_ProcessingItemTaskLabel;
        monitor.subTask(MessageFormat.format(subtask, resolution.getName()));
        ArrayList<UnresolvedNode> nodes = new ArrayList<UnresolvedNode>(children.size());
        for (ComponentRequest componentRequest : children) {
            if (monitor.isCanceled()) {
                return new UnresolvedNode(new QualifiedDependency(componentRequest, EMPTY_SET));
            }
            UnresolvedNode child = null;
            try {
                Resolution childResolution = WorkspaceInfo.resolveLocal((IComponentRequest)componentRequest, (boolean)true);
                UUID resolutionID = childResolution.getId();
                if (bomCache.containsKey(resolutionID)) {
                    child = bomCache.get(resolutionID);
                } else {
                    UnresolvedNode dummyNode = new UnresolvedNode(new QualifiedDependency(componentRequest, EMPTY_SET));
                    bomCache.put(resolutionID, (BOMNode)dummyNode);
                    child = this.buildBOM(childResolution, bomCache, monitor.newChild(100));
                    bomCache.put(resolutionID, (BOMNode)child);
                }
            }
            catch (MissingComponentException e) {
                child = new UnresolvedNode(new QualifiedDependency(componentRequest, EMPTY_SET));
                monitor.worked(100);
            }
            nodes.add(child);
        }
        monitor.done();
        ResolvedNode thisBom = new ResolvedNode(resolution, nodes);
        bomCache.put(resolution.getId(), (BOMNode)thisBom);
        return thisBom;
    }

    protected void run(CSpec cspec, Shell shell) {
        final ComponentRequest request = new ComponentRequest(cspec.getComponentIdentifier().getName(), cspec.getComponentIdentifier().getComponentTypeID(), null);
        Job computeResolution = new Job(Messages.OpenDepencencyGraphAction_ResolvingDependencyGraphJobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Resolution resolution = WorkspaceInfo.resolveLocal((IComponentRequest)request, (boolean)true);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    BOMNode node = OpenDepencencyGraphAction.this.buildBOM(resolution, new HashMap(), subMonitor);
                    ComponentQueryBuilder builder = new ComponentQueryBuilder();
                    builder.setRootRequest((IComponentRequest)request);
                    BillOfMaterials bom = new BillOfMaterials(node, builder.createComponentQuery(), new Date());
                    final BOMEditorInput input = new BOMEditorInput(bom);
                    OpenDepencencyGraphAction.this.activePart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IDE.openEditor((IWorkbenchPage)OpenDepencencyGraphAction.this.activePart.getSite().getPage(), (IEditorInput)input, (String)"org.eclipse.buckminster.dependency.visualizer.editor1");
                            }
                            catch (PartInitException e) {
                                UiUtils.openError((Shell)OpenDepencencyGraphAction.this.activePart.getSite().getShell(), (String)Messages.OpenDepencencyGraphAction_OpenEditorErrorMessage, (Throwable)e);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.buckminster.ui.dependency.visualizer", e.getLocalizedMessage());
                }
            }
        };
        computeResolution.setUser(true);
        computeResolution.schedule();
    }
}

