/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExternalFileEditorInput
implements IPathEditorInput,
ILocationProvider,
IWorkbenchAdapter {
    private final String label;
    private final String tooltipText;
    private final File file;
    Dialog x;

    public ExternalFileEditorInput(File file) {
        this(file, file.getName(), file.getAbsolutePath());
    }

    public ExternalFileEditorInput(File file, String label, String tooltipText) {
        this.file = file;
        this.label = label;
        this.tooltipText = tooltipText;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalFileEditorInput)) {
            return false;
        }
        ExternalFileEditorInput that = (ExternalFileEditorInput)o;
        return this.getPath().equals((Object)that.getPath());
    }

    public boolean exists() {
        return this.file.exists();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ILocationProvider.class.equals(adapter) || IWorkbenchAdapter.class.equals(adapter)) {
            return (T)this;
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected IWorkbenchAdapter[] getChildren() {
        File[] childrenFiles = this.file.listFiles();
        int idx = childrenFiles.length;
        IWorkbenchAdapter[] children = new ExternalFileEditorInput[idx];
        while (--idx >= 0) {
            children[idx] = new ExternalFileEditorInput(childrenFiles[idx]);
        }
        return children;
    }

    public Object[] getChildren(Object o) {
        return o instanceof ExternalFileEditorInput ? ((ExternalFileEditorInput)o).getChildren() : null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        return o instanceof IEditorInput ? ((IEditorInput)o).getImageDescriptor() : null;
    }

    public String getLabel(Object o) {
        return o instanceof ExternalFileEditorInput ? ((ExternalFileEditorInput)o).getName() : null;
    }

    public String getName() {
        return this.label;
    }

    protected IWorkbenchAdapter getParent() {
        File parentFile = this.file.getParentFile();
        return parentFile == null ? null : new ExternalFileEditorInput(parentFile);
    }

    public Object getParent(Object o) {
        return o instanceof ExternalFileEditorInput ? ((ExternalFileEditorInput)o).getParent() : null;
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.file.getAbsolutePath());
    }

    public IPath getPath(Object o) {
        return o instanceof IPathEditorInput ? ((IPathEditorInput)o).getPath() : null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.tooltipText;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

