/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.general.editor.IValidator;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.WidgetWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.InvalidSyntaxException;

public class PrerequisitesTable
extends SimpleTable<PrerequisiteBuilder> {
    private CSpecEditor editor;
    private AttributesTable<?> parentAttributesTable;
    private TopLevelAttributeBuilder attributeBuilder;
    private IWidgetin componentWidgetin = null;
    private IWidgetin typeWidgetin = null;
    private IWidgetin rangeWidgetin = null;
    private IWidgetin attributeWidgetin = null;

    public PrerequisitesTable(CSpecEditor editor, AttributesTable<?> parentAttributesTable, List<PrerequisiteBuilder> data, TopLevelAttributeBuilder attributeBuilder, boolean readOnly) {
        super(data, readOnly);
        this.editor = editor;
        this.parentAttributesTable = parentAttributesTable;
        this.attributeBuilder = attributeBuilder;
    }

    @Override
    public PrerequisiteBuilder createRowClass() {
        return this.attributeBuilder.createPrerequisiteBuilder();
    }

    @Override
    public String[] getColumnHeaders() {
        return new String[]{Messages.component, Messages.type, Messages.version_designator, Messages.attribute, Messages.alias, Messages.contributor, Messages.filter, Messages.include_pattern, Messages.exclude_pattern};
    }

    @Override
    public int[] getColumnWeights() {
        int[] nArray = new int[9];
        nArray[0] = 20;
        nArray[1] = 5;
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[4] = 10;
        return nArray;
    }

    @Override
    public IValidator getRowValidator() {
        return new IValidator(){

            @Override
            public void validate(Object ... arg) throws ValidatorException {
                PrerequisiteBuilder prerequisite = (PrerequisiteBuilder)PrerequisitesTable.this.toRowClass((Object[])arg[1]);
                if (!(prerequisite.getName() != null && prerequisite.getName().length() != 0 || prerequisite.getComponentName() != null && prerequisite.getComponentName().length() != 0)) {
                    throw new ValidatorException(Messages.name_or_component_has_to_be_entered);
                }
            }
        };
    }

    @Override
    public IWidgetin getWidgetin(Composite parent, int idx, Object value) {
        switch (idx) {
            case 0: {
                this.componentWidgetin = this.getComponentWidgetin(parent, idx, value, this.editor.getComponentNames(), 0);
                return this.componentWidgetin;
            }
            case 1: {
                this.typeWidgetin = this.getTypeWidgetin(parent, idx, value, 0);
                return this.typeWidgetin;
            }
            case 2: {
                this.rangeWidgetin = this.getTextWidgetin(parent, idx, value);
                return this.rangeWidgetin;
            }
            case 3: {
                this.attributeWidgetin = this.getAttributeWidgetin(parent, idx, value, this.editor.getAttributeNames(this.parentAttributesTable.getCurrentBuilder().getName()), 0);
                this.setAttributeItems();
                return this.attributeWidgetin;
            }
            case 5: {
                return this.getBooleanCheckBoxWidgetin(parent, idx, (Boolean)value, Boolean.TRUE);
            }
        }
        return this.getTextWidgetin(parent, idx, value);
    }

    @Override
    public Object[] toRowArray(PrerequisiteBuilder t) {
        return new Object[]{t.getComponentName(), TextUtils.notNullString((Object)t.getComponentType()), TextUtils.notNullString((Object)t.getVersionRange()), t.getName(), t.getAlias(), t.isContributor(), TextUtils.notNullString((Object)t.getFilter()), TextUtils.notNullString((Object)t.getIncludePattern()), TextUtils.notNullString((Object)t.getExcludePattern())};
    }

    @Override
    public void updateRowClass(PrerequisiteBuilder builder, Object[] args) throws ValidatorException {
        builder.setComponentName(TextUtils.notEmptyString((String)((String)args[0])));
        builder.setComponentType(TextUtils.notEmptyString((String)((String)args[1])));
        String vrStr = TextUtils.notEmptyString((String)((String)args[2]));
        if (vrStr != null) {
            try {
                builder.setVersionRange(new VersionRange(vrStr));
            }
            catch (IllegalArgumentException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setVersionRange(null);
        }
        builder.setName(TextUtils.notEmptyString((String)((String)args[3])));
        builder.setAlias(TextUtils.notEmptyString((String)((String)args[4])));
        builder.setContributor(((Boolean)args[5]).booleanValue());
        String filterStr = TextUtils.notEmptyString((String)((String)args[6]));
        if (filterStr != null) {
            try {
                builder.setFilter(FilterFactory.newInstance((String)filterStr));
            }
            catch (InvalidSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setFilter(null);
        }
        String includePatternStr = TextUtils.notEmptyString((String)((String)args[7]));
        if (includePatternStr != null) {
            try {
                builder.setIncludePattern(Pattern.compile(includePatternStr));
            }
            catch (PatternSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setIncludePattern(null);
        }
        String excludePatternStr = TextUtils.notEmptyString((String)((String)args[8]));
        if (excludePatternStr != null) {
            try {
                builder.setExcludePattern(Pattern.compile(excludePatternStr));
            }
            catch (PatternSyntaxException e) {
                throw new ValidatorException(e.getMessage());
            }
        } else {
            builder.setExcludePattern(null);
        }
    }

    protected IWidgetin getAttributeWidgetin(Composite parent, final int idx, Object value, String[] items, int style) {
        String ITEMS_KEY = "items";
        final Combo combo = UiUtils.createGridCombo(parent, 0, 0, this.isReadOnly(), null, null, style);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)combo);
        String stringValue = value == null ? "" : value.toString();
        combo.setText(stringValue);
        combo.setData((Object)stringValue);
        combo.setData("items", (Object)items);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                combo.setData((Object)combo.getText());
                PrerequisitesTable.this.validateFieldInFieldListener(widgetin, PrerequisitesTable.this.getFieldValidator(idx), combo.getText());
            }
        });
        return widgetin;
    }

    protected IWidgetin getComponentWidgetin(Composite parent, final int idx, Object value, String[] items, int style) {
        final Combo combo = UiUtils.createGridCombo(parent, 0, 0, this.isReadOnly(), null, null, style);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)combo);
        combo.setItems(items);
        String stringValue = value == null ? "" : value.toString();
        combo.setText(stringValue);
        combo.setData((Object)stringValue);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                combo.setData((Object)combo.getText());
                PrerequisitesTable.this.validateFieldInFieldListener(widgetin, PrerequisitesTable.this.getFieldValidator(idx), combo.getText());
                PrerequisitesTable.this.setAttributeItems();
            }
        });
        return widgetin;
    }

    protected IWidgetin getTypeWidgetin(Composite parent, final int idx, Object value, int style) {
        final Combo combo = UiUtils.createGridCombo(parent, 0, 0, this.isReadOnly(), null, null, style);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)combo);
        combo.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        String stringValue = value == null ? "" : value.toString();
        combo.setText(stringValue);
        combo.setData((Object)stringValue);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                combo.setData((Object)combo.getText());
                PrerequisitesTable.this.validateFieldInFieldListener(widgetin, PrerequisitesTable.this.getFieldValidator(idx), combo.getText());
                PrerequisitesTable.this.setAttributeItems();
            }
        });
        return widgetin;
    }

    private void setAttributeItems() {
        if (this.componentWidgetin == null || this.attributeWidgetin == null) {
            return;
        }
        Combo componentCombo = (Combo)((WidgetWrapper)this.componentWidgetin).getWidget();
        Combo typeCombo = (Combo)((WidgetWrapper)this.typeWidgetin).getWidget();
        Text rangeText = (Text)((WidgetWrapper)this.rangeWidgetin).getWidget();
        Combo attributeCombo = (Combo)((WidgetWrapper)this.attributeWidgetin).getWidget();
        String currentAttribute = attributeCombo.getText();
        if (componentCombo.getText() == null || componentCombo.getText().length() == 0) {
            attributeCombo.setItems((String[])attributeCombo.getData("items"));
        } else {
            ComponentRequestBuilder builder = this.editor.getDependencyBuilder(componentCombo.getText(), typeCombo.getText(), rangeText.getText());
            ComponentRequest cr = new ComponentRequest(builder.getName(), builder.getComponentTypeID(), builder.getVersionRange());
            TreeSet<String> prereqAttributes = new TreeSet<String>();
            try {
                Resolution prereqResolution = WorkspaceInfo.getResolution((ComponentRequest)cr, (boolean)false);
                CSpec prereqCSpec = prereqResolution.getCSpec();
                for (Attribute attribute : prereqCSpec.getAttributes().values()) {
                    if (!attribute.isPublic()) continue;
                    prereqAttributes.add(attribute.getName());
                }
            }
            catch (MissingComponentException prereqResolution) {
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.editor.getSite().getShell(), null, (String)Messages.cannot_get_attribute_names_for_the_selected_component, (IStatus)e.getStatus());
            }
            attributeCombo.setItems(prereqAttributes.toArray(new String[0]));
        }
        attributeCombo.setText(currentAttribute);
        attributeCombo.update();
    }
}

