/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class TableRowDialog
extends TitleAreaDialog {
    private final Image windowImage;
    private final String windowTitle;
    private final Image wizardImage;
    private final String helpURL;
    private final boolean newRow;
    private final boolean readOnly;

    public TableRowDialog(Shell parentShell, Image windowImage, String windowTitle, Image wizardImage, String helpURL, boolean newRow, boolean readOnly) {
        super(parentShell);
        this.windowImage = windowImage;
        this.windowTitle = windowTitle;
        this.wizardImage = wizardImage;
        this.helpURL = helpURL;
        this.newRow = newRow;
        this.readOnly = readOnly;
    }

    public boolean isHelpAvailable() {
        return this.helpURL != null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.windowTitle);
        if (this.windowImage != null) {
            newShell.setImage(this.windowImage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.isReadOnly()) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.enableDisableOkButton();
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.wizardImage != null) {
            this.setTitleImage(this.wizardImage);
        }
        if (this.isReadOnly()) {
            this.setTitle(Messages.view_row);
            this.setMessage(Messages.view_row_fields);
        } else if (this.newRow) {
            this.setTitle(Messages.new_row);
            this.setMessage(Messages.enter_new_row_fields);
        } else {
            this.setTitle(Messages.edit_row);
            this.setMessage(Messages.edit_row_fields);
        }
        return contents;
    }

    protected Control createHelpControl(Composite parent) {
        Control helpControl = super.createHelpControl(parent);
        helpControl.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (TableRowDialog.this.helpURL != null) {
                    Program.launch((String)TableRowDialog.this.helpURL);
                }
            }
        });
        return helpControl;
    }

    protected abstract void enableDisableOkButton();

    protected boolean isReadOnly() {
        return this.readOnly;
    }
}

