/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.structured;

import org.eclipse.buckminster.ui.general.editor.TableRowDialog;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.IStructuredTable;
import org.eclipse.buckminster.ui.general.editor.structured.StructuredTableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TwoPagesTableEditor<T>
extends StructuredTableEditor<T> {
    private final Image windowImage;
    private final String windowTitle;
    private final Image wizardImage;
    private final String helpURL;

    public TwoPagesTableEditor(Composite parent, IStructuredTable<T> table, boolean swapButtonsFlag, Image windowImage, String windowTitle, Image wizardImage, String helpURL, int style) {
        super(parent, table, swapButtonsFlag, style);
        this.windowImage = windowImage;
        this.windowTitle = windowTitle;
        this.wizardImage = wizardImage;
        this.helpURL = helpURL;
    }

    @Override
    public void refresh() {
        this.refreshTable();
        this.enableDisableButtonGroup();
    }

    public boolean show(T row) {
        return this.selectRow(row);
    }

    @Override
    protected Composite createTableGroupComposite(Composite parent) {
        Composite componentTableGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        componentTableGroup.setLayout((Layout)gl);
        componentTableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        return componentTableGroup;
    }

    @Override
    protected void editRow(boolean newRow, boolean readOnly) {
        new EditRowDialog(this.getShell(), this.windowImage, this.windowTitle, this.wizardImage, this.helpURL, newRow, readOnly).open();
    }

    @Override
    protected void initComposite() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        this.createTableGroup(this);
    }

    @Override
    protected void newRow() {
        this.getTableViewer().getTable().deselectAll();
        this.updateLastRow();
        this.editRow(true, false);
    }

    @Override
    protected boolean rowSelectionEvent() {
        this.enableDisableButtonGroup();
        return true;
    }

    class EditRowDialog
    extends TableRowDialog {
        public EditRowDialog(Shell parentShell, Image windowImage, String windowTitle, Image wizardImage, String helpURL, boolean newRow, boolean readOnly) {
            super(parentShell, windowImage, windowTitle, wizardImage, helpURL, newRow, readOnly);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                try {
                    TwoPagesTableEditor.this.saveRow();
                }
                catch (ValidatorException e) {
                    this.setErrorMessage(e.getMessage());
                    return;
                }
            }
            this.setReturnCode(buttonId);
            this.close();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite rowComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            rowComposite.setLayout((Layout)layout);
            GridData gridData = new GridData(4, 4, true, true);
            rowComposite.setLayoutData((Object)gridData);
            TwoPagesTableEditor.this.createStackOptions(rowComposite);
            TwoPagesTableEditor.this.createStack(rowComposite);
            TwoPagesTableEditor.this.fillStackOptions();
            TwoPagesTableEditor.this.refreshRow();
            TwoPagesTableEditor.this.focusStackComposite();
            return rowComposite;
        }

        @Override
        protected void enableDisableOkButton() {
            if (this.isReadOnly()) {
                this.getButton(0).setEnabled(true);
            }
        }
    }
}

