/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.prefs;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PasswordFieldEditor
extends StringFieldEditor {
    private static final String BUCKMINSTER_NODE = "buckminster";
    private String keyRingRealm;
    private Text textField;
    private int textLimit = UNLIMITED;
    private int validateStrategy = 0;

    public PasswordFieldEditor(String name, String labelText, Composite parent, String keyRingRealm) {
        this(name, labelText, UNLIMITED, parent, keyRingRealm);
    }

    public PasswordFieldEditor(String name, String labelText, int width, Composite parent, String keyRingRealm) {
        this(name, labelText, width, 0, parent, keyRingRealm);
    }

    public PasswordFieldEditor(String name, String labelText, int width, int strategy, Composite parent, String keyRingRealm) {
        super(name, labelText, width, strategy, parent);
        this.keyRingRealm = keyRingRealm;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPasswordFromKeyRing();
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 0x400804);
            this.textField.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            PasswordFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            PasswordFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            PasswordFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            PasswordFieldEditor.this.valueChanged();
                            PasswordFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PasswordFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPasswordFromKeyRing();
            this.textField.setText(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = "";
            this.textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.setPasswordToKeyRing(this.textField.getText());
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid();
        this.refreshValidState();
        if (this.isValid() != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid());
        }
        if (!(newValue = this.textField.getText()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    private String getPasswordFromKeyRing() {
        ISecurePreferences info = SecurePreferencesFactory.getDefault().node(BUCKMINSTER_NODE).node(this.keyRingRealm);
        try {
            return info.get(this.getPreferenceName(), "");
        }
        catch (StorageException e) {
            return "";
        }
    }

    private void setPasswordToKeyRing(String password) {
        ISecurePreferences info = SecurePreferencesFactory.getDefault().node(BUCKMINSTER_NODE).node(this.keyRingRealm);
        try {
            info.put(this.getPreferenceName(), password, true);
            info.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.cannot_save_password, e);
        }
    }
}

