/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.views;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;
import org.eclipse.buckminster.generic.ui.GenericUiPlugin;
import org.eclipse.buckminster.generic.ui.actions.IBrowseable;
import org.eclipse.buckminster.generic.ui.actions.IBrowseableFeed;
import org.eclipse.buckminster.generic.ui.actions.ViewInBrowserAction;
import org.eclipse.buckminster.ui.InvokeActionJob;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.ViewCSpecAction;
import org.eclipse.buckminster.ui.dialogs.InvokeActionDialog;
import org.eclipse.buckminster.ui.providers.BuckminsterLabelProvider;
import org.eclipse.buckminster.ui.providers.ResolutionsTreeContentProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ComponentBrowserView
extends ViewPart {
    protected TreeViewer viewer;
    private Action refreshAction;
    private Action doubleClickAction;
    private ViewInBrowserAction viewInBrowser;
    private ViewInBrowserAction viewInExternalBrowser;
    private ViewInBrowserAction viewFeedInBrowser;

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BuckminsterLabelProvider()));
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object o = event.getElement();
                if (o instanceof ITreeParentDataNode) {
                    ((ITreeParentDataNode)o).onOpen();
                }
            }
        });
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        manager.add((IContributionItem)new Separator("default"));
        if (obj instanceof IAdaptable) {
            if (((IAdaptable)obj).getAdapter(IBrowseableFeed.class) != null) {
                manager.add((org.eclipse.jface.action.IAction)this.viewFeedInBrowser);
            }
            if (((IAdaptable)obj).getAdapter(IBrowseable.class) != null) {
                manager.add((org.eclipse.jface.action.IAction)this.viewInBrowser);
                manager.add((org.eclipse.jface.action.IAction)this.viewInExternalBrowser);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((org.eclipse.jface.action.IAction)this.refreshAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((org.eclipse.jface.action.IAction)this.refreshAction);
    }

    protected ResolutionsTreeContentProvider getContentProvider() {
        return new ResolutionsTreeContentProvider();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ComponentBrowserView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ComponentBrowserView.this.doubleClickAction.run();
            }
        });
    }

    public boolean isAutoExpand() {
        return false;
    }

    private void makeActions() {
        this.viewInBrowser = new ViewInBrowserAction((Viewer)this.viewer, true, Messages.content, false);
        this.viewInExternalBrowser = new ViewInBrowserAction((Viewer)this.viewer, false, Messages.content, false);
        this.viewFeedInBrowser = new ViewInBrowserAction((Viewer)this.viewer, false, Messages.feed, true);
        this.refreshAction = new Action(){

            public void run() {
                ComponentBrowserView.this.viewer.setInput((Object)ComponentBrowserView.this.getViewSite());
            }
        };
        this.refreshAction.setText(Messages.refresh);
        this.refreshAction.setToolTipText(Messages.refresh_component_explorer);
        this.refreshAction.setImageDescriptor(GenericUiPlugin.getImageDescriptor((String)"icons/refresh.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ComponentBrowserView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IAdaptable) {
                    IObjectActionDelegate delegate;
                    ICSpecData cspec = (ICSpecData)((IAdaptable)obj).getAdapter(CSpec.class);
                    if (cspec != null) {
                        ViewCSpecAction vca = new ViewCSpecAction();
                        vca.setActivePart((org.eclipse.jface.action.IAction)this, ComponentBrowserView.this.getSite().getPart());
                        vca.selectionChanged((org.eclipse.jface.action.IAction)this, selection);
                        vca.run((org.eclipse.jface.action.IAction)this);
                        return;
                    }
                    Attribute attribute = (Attribute)((IAdaptable)obj).getAdapter(IAction.class);
                    if (attribute != null) {
                        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                        attributes.add(attribute);
                        InvokeActionDialog dialog = new InvokeActionDialog(ComponentBrowserView.this.getSite().getShell(), Messages.invoke_action, attributes);
                        if (dialog.open() == 0) {
                            File propertiesFile = dialog.getPropertiesFile();
                            boolean forceRebuild = dialog.isForceRebuild();
                            InvokeActionJob job = new InvokeActionJob(attributes.get(0).getName(), attributes, propertiesFile, forceRebuild);
                            job.schedule();
                        }
                        return;
                    }
                    IBrowseableFeed feed = (IBrowseableFeed)((IAdaptable)obj).getAdapter(IBrowseableFeed.class);
                    if (feed != null && (delegate = UiPlugin.getDefault().getOpenRssFeedAction()) != null) {
                        delegate.setActivePart((org.eclipse.jface.action.IAction)this, (IWorkbenchPart)ComponentBrowserView.this);
                        delegate.selectionChanged((org.eclipse.jface.action.IAction)this, (ISelection)new StructuredSelection((Object)feed));
                        delegate.run((org.eclipse.jface.action.IAction)this);
                        return;
                    }
                    IBrowseable site = (IBrowseable)((IAdaptable)obj).getAdapter(IBrowseable.class);
                    if (site != null) {
                        ComponentBrowserView.this.viewInBrowser.run();
                        return;
                    }
                }
            }
        };
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

