/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.wizards.AbstractQueryPage;
import org.eclipse.buckminster.ui.wizards.ResolverNodePage;
import org.eclipse.buckminster.ui.wizards.RetrieveAndBindPage;
import org.eclipse.buckminster.ui.wizards.SelectBOMPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class QueryWizard
extends Wizard
implements INewWizard {
    private final MaterializationSpecBuilder mspec;
    private MaterializationContext materializationContext;
    private ResolutionContext context;
    private BillOfMaterials bom;

    public static void openWizard(IWorkbenchPart targetPart, IStructuredSelection selection) {
        QueryWizard wizard = new QueryWizard();
        IWorkbenchPartSite site = targetPart.getSite();
        wizard.init(site.getWorkbenchWindow().getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(site.getShell(), (IWizard)wizard);
        dialog.setPageSize(300, 480);
        dialog.open();
    }

    public static void openWizard(IWorkbenchPartSite site, ResolutionContext context, BillOfMaterials bom) {
        QueryWizard wizard = new QueryWizard(context, bom);
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(site.getShell(), (IWizard)wizard);
        dialog.setPageSize(300, 480);
        dialog.open();
    }

    public QueryWizard() {
        this(null, null);
    }

    private QueryWizard(ResolutionContext context, BillOfMaterials bom) {
        this.context = context;
        this.mspec = new MaterializationSpecBuilder();
        if (bom != null) {
            try {
                this.setBOM(bom);
            }
            catch (CoreException e) {
                CorePlugin.getLogger().error((Throwable)e, e.toString(), new Object[0]);
            }
        }
    }

    BillOfMaterials getBOM() {
        if (this.bom == null) {
            throw new IllegalStateException(Messages.wizard_not_yet_initialized_with_bom);
        }
        return this.bom;
    }

    ResolutionContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException(Messages.wizard_not_yet_initialized_with_bom);
        }
        return this.context;
    }

    public MaterializationContext getMaterializationContext() {
        if (this.materializationContext == null) {
            this.materializationContext = new MaterializationContext(this.getBOM(), this.mspec.createMaterializationSpec(), (RMContext)this.getContext());
            this.materializationContext.setContinueOnError(this.context.isContinueOnError());
        }
        return this.materializationContext;
    }

    MaterializationSpecBuilder getMaterializationSpec() {
        return this.mspec;
    }

    boolean hasBOM() {
        return this.bom != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        AbstractQueryPage page;
        String title = Messages.buckminster_component_query;
        this.setNeedsProgressMonitor(true);
        if (this.bom == null) {
            page = new SelectBOMPage(selection);
            page.setTitle(title);
            this.addPage((IWizardPage)page);
        }
        page = new ResolverNodePage();
        page.setTitle(title);
        this.addPage((IWizardPage)page);
        page = new RetrieveAndBindPage();
        page.setTitle(title);
        this.addPage((IWizardPage)page);
    }

    void invalidateMaterializationContext() {
        this.materializationContext = null;
    }

    public boolean performFinish() {
        if (this.getBOM() == null) {
            return false;
        }
        try {
            MaterializationJob job = new MaterializationJob(this.getMaterializationContext());
            job.schedule();
            return true;
        }
        catch (Exception e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            ByteArrayOutputStream bld = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(bld);
            BuckminsterException.deeplyPrint((Throwable)t, (PrintStream)p, (boolean)Buckminster.getLogger().isDebugEnabled());
            p.flush();
            String msg = new String(bld.toByteArray());
            CorePlugin.getLogger().error(t, msg, new Object[0]);
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(msg);
            return false;
        }
    }

    public void resetBOM() {
        this.bom = null;
    }

    void setBOM(BillOfMaterials bom) throws CoreException {
        this.bom = bom;
        if (this.context == null) {
            this.context = new ResolutionContext(bom.getQuery());
        }
        this.mspec.setName(bom.getViewName());
        bom.addMaterializationNodes(this.mspec);
    }
}

