/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.json;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JsonDataSource;

public class JsonDataAdapterService
extends AbstractDataAdapterService {
    private DataFileStream dataStream;

    public JsonDataAdapterService(JasperReportsContext jasperReportsContext, JsonDataAdapter jsonDataAdapter) {
        super(jasperReportsContext, jsonDataAdapter);
    }

    public JsonDataAdapter getJsonDataAdapter() {
        return (JsonDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JsonDataAdapter jsonDataAdapter = this.getJsonDataAdapter();
        if (jsonDataAdapter != null) {
            this.dataStream = DataFileUtils.instance(this.getJasperReportsContext()).getDataStream(jsonDataAdapter.getDataFile(), parameters);
            if (jsonDataAdapter.isUseConnection()) {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                parameters.put("JSON_INPUT_STREAM", this.dataStream);
                Locale locale = jsonDataAdapter.getLocale();
                if (locale != null) {
                    parameters.put("JSON_LOCALE", locale);
                }
                if ((timeZone = jsonDataAdapter.getTimeZone()) != null) {
                    parameters.put("JSON_TIME_ZONE", timeZone);
                }
                if ((datePattern = jsonDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    parameters.put("net.sf.jasperreports.json.date.pattern", datePattern);
                }
                if ((numberPattern = jsonDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    parameters.put("net.sf.jasperreports.json.number.pattern", numberPattern);
                }
            } else {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                JsonDataSource ds = new JsonDataSource(this.dataStream, jsonDataAdapter.getSelectExpression());
                Locale locale = jsonDataAdapter.getLocale();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if ((timeZone = jsonDataAdapter.getTimeZone()) != null) {
                    ds.setTimeZone(timeZone);
                }
                if ((datePattern = jsonDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    ds.setDatePattern(datePattern);
                }
                if ((numberPattern = jsonDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    ds.setNumberPattern(numberPattern);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.dataStream != null) {
            this.dataStream.dispose();
        }
        super.dispose();
    }
}

