/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.FillReturnValues;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillBand
extends JRFillElementContainer
implements JRBand,
JROriginProvider {
    private static final Log log = LogFactory.getLog(JRFillBand.class);
    private JRBand parent;
    private boolean isPrintWhenTrue = true;
    private boolean isNewPageColumn;
    private boolean isFirstWholeOnPageColumn;
    private Map<JRGroup, Boolean> isNewGroupMap = new HashMap<JRGroup, Boolean>();
    private Set<JREvaluationTime> nowEvaluationTimes;
    private Map<String, Object> savedVariableValues = new HashMap<String, Object>();
    protected JROrigin origin;
    private SplitTypeEnum splitType;
    private int breakHeight;
    private FillReturnValues returnValues;
    private FillReturnValues.SourceContext returnValuesContext = new FillReturnValues.SourceContext(){

        @Override
        public Object getValue(CommonReturnValue returnValue) {
            ExpressionReturnValue expressionReturnValue = (ExpressionReturnValue)returnValue;
            Object value = null;
            try {
                value = JRFillBand.this.filler.evaluateExpression(expressionReturnValue.getExpression(), (byte)3);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            return value;
        }

        @Override
        public void check(CommonReturnValue returnValue) throws JRException {
        }
    };
    private Set<FillReturnValues> returnValuesSet;

    protected JRFillBand(JRBaseFiller filler, JRBand band, JRFillObjectFactory factory) {
        super(filler, band, factory);
        List<ExpressionReturnValue> expRetValues;
        this.parent = band;
        this.returnValuesSet = new LinkedHashSet<FillReturnValues>();
        if (this.deepElements.length > 0) {
            for (int i = 0; i < this.deepElements.length; ++i) {
                this.deepElements[i].setBand(this);
            }
        }
        this.returnValues = new FillReturnValues((expRetValues = this.getReturnValues()) == null ? null : expRetValues.toArray(new ExpressionReturnValue[expRetValues.size()]), factory, (BaseReportFiller)filler);
        this.registerReturnValues(this.returnValues);
        SplitTypeEnum splitTypeEnum = this.splitType = this.parent == null ? null : this.parent.getSplitTypeValue();
        if (this.splitType == null) {
            this.splitType = SplitTypeEnum.getByName(filler.getPropertiesUtil().getProperty(filler.getJasperReport(), "net.sf.jasperreports.band.split.type"));
        }
        this.breakHeight = this.getHeight();
        if (SplitTypeEnum.IMMEDIATE == this.getSplitTypeValue() && this.elements != null && this.elements.length > 0) {
            for (int i = 0; i < this.elements.length; ++i) {
                JRFillElement element = this.elements[i];
                int bottom = element.getY() + element.getHeight();
                this.breakHeight = bottom < this.breakHeight ? bottom : this.breakHeight;
            }
        }
        this.initElements();
        this.initConditionalStyles();
        this.nowEvaluationTimes = new HashSet<JREvaluationTime>();
    }

    @Override
    public JROrigin getOrigin() {
        return this.origin;
    }

    protected void setOrigin(JROrigin origin) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Origin " + origin + " for band " + this.getId()));
        }
        this.origin = origin;
        this.filler.getJasperPrint().addOrigin(origin);
    }

    protected void setNewPageColumn(boolean isNew) {
        this.isNewPageColumn = isNew;
    }

    protected boolean isNewPageColumn() {
        return this.isNewPageColumn;
    }

    protected boolean isFirstWholeOnPageColumn() {
        return this.isFirstWholeOnPageColumn;
    }

    protected void setNewGroup(JRGroup group, boolean isNew) {
        this.isNewGroupMap.put(group, isNew ? Boolean.TRUE : Boolean.FALSE);
    }

    protected boolean isNewGroup(JRGroup group) {
        Boolean value = this.isNewGroupMap.get(group);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    @Override
    public int getHeight() {
        return this.parent == null ? 0 : this.parent.getHeight();
    }

    public int getBreakHeight() {
        return this.breakHeight;
    }

    @Override
    public SplitTypeEnum getSplitTypeValue() {
        return this.splitType;
    }

    @Override
    public void setSplitType(SplitTypeEnum splitType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.parent == null ? null : this.parent.getPrintWhenExpression();
    }

    protected boolean isSplitPrevented() {
        return SplitTypeEnum.PREVENT == this.getSplitTypeValue();
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.getPrintWhenExpression() == null;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue();
    }

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isPrintTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            Boolean printWhenExpressionValue = (Boolean)this.filler.evaluateExpression(expression, evaluation);
            isPrintTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenTrue(isPrintTrue);
    }

    protected JRPrintBand refill(int availableHeight) throws JRException {
        this.rewind();
        this.restoreSavedVariables();
        return this.fill(availableHeight);
    }

    protected JRPrintBand fill() throws JRException {
        return this.fill(this.getHeight(), false);
    }

    protected JRPrintBand fill(int availableHeight) throws JRException {
        return this.fill(availableHeight, true);
    }

    protected JRPrintBand fill(int availableHeight, boolean isOverflowAllowed) throws JRException {
        this.filler.checkInterrupted();
        this.filler.setBandOverFlowAllowed(isOverflowAllowed);
        this.initFill();
        if (this.isNewPageColumn && !this.isOverflow) {
            this.isFirstWholeOnPageColumn = true;
        }
        this.resetElements();
        this.prepareElements(availableHeight, isOverflowAllowed);
        if (this.isLegacyElementStretchEnabled()) {
            this.stretchElements();
            this.moveBandBottomElements();
            this.removeBlankElements();
        }
        this.isFirstWholeOnPageColumn = this.isNewPageColumn && this.isOverflow;
        this.isNewPageColumn = false;
        this.isNewGroupMap = new HashMap<JRGroup, Boolean>();
        JRPrintBand printBand = new JRPrintBand();
        this.fillElements(printBand);
        if (!this.willOverflow()) {
            this.returnValues.copyValues(this.returnValuesContext);
        }
        return printBand;
    }

    @Override
    protected int getContainerHeight() {
        return this.getHeight();
    }

    @Override
    protected int getActualContainerHeight() {
        return this.getContainerHeight();
    }

    protected boolean isVariableUsedInReturns(String variableName) {
        boolean used = false;
        for (FillReturnValues returnValues : this.returnValuesSet) {
            if (!returnValues.usesForReturnValue(variableName)) continue;
            used = true;
            break;
        }
        return used;
    }

    protected void addNowEvaluationTime(JREvaluationTime evaluationTime) {
        this.nowEvaluationTimes.add(evaluationTime);
    }

    protected void addNowEvaluationTimes(JREvaluationTime[] evaluationTimes) {
        for (int i = 0; i < evaluationTimes.length; ++i) {
            this.nowEvaluationTimes.add(evaluationTimes[i]);
        }
    }

    protected boolean isNowEvaluationTime(JREvaluationTime evaluationTime) {
        return this.nowEvaluationTimes.contains(evaluationTime);
    }

    protected int getId() {
        return System.identityHashCode(this);
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.resetSavedVariables();
        this.evaluateConditionalStyles(evaluation);
        super.evaluate(evaluation);
    }

    protected void resetSavedVariables() {
        this.savedVariableValues.clear();
    }

    protected void saveVariable(String variableName) {
        if (!this.savedVariableValues.containsKey(variableName)) {
            Object value = this.filler.getVariableValue(variableName);
            this.savedVariableValues.put(variableName, value);
        }
    }

    protected void restoreSavedVariables() {
        for (Map.Entry<String, Object> entry : this.savedVariableValues.entrySet()) {
            String variableName = entry.getKey();
            Object value = entry.getValue();
            JRFillVariable variable = this.filler.getVariable(variableName);
            variable.setOldValue(value);
            variable.setValue(value);
            variable.setIncrementedValue(value);
        }
    }

    protected boolean isEmpty() {
        return this == this.filler.missingFillBand || this.getHeight() == 0 && (this.getElements() == null || this.getElements().length == 0) && this.getPrintWhenExpression() == null;
    }

    protected boolean isPageBreakInhibited() {
        boolean isPageBreakInhibited;
        boolean bl = isPageBreakInhibited = this.filler.isFirstPageBand && !this.atLeastOneElementIsToPrint;
        if (isPageBreakInhibited && this.filler.isSubreport()) {
            isPageBreakInhibited = this.filler.bandReportParent.isPageBreakInhibited();
        }
        return isPageBreakInhibited;
    }

    @Override
    public boolean hasProperties() {
        return this.parent.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.parent.getPropertiesMap();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public List<ExpressionReturnValue> getReturnValues() {
        return this.parent == null ? null : this.parent.getReturnValues();
    }

    public void registerReturnValues(FillReturnValues fillReturnValues) {
        this.returnValuesSet.add(fillReturnValues);
    }
}

