/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.olap4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.olap.olap4j.Olap4jFactory;
import net.sf.jasperreports.olap.olap4j.Olap4jHierarchy;
import net.sf.jasperreports.olap.olap4j.Olap4jTuple;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;

public class Olap4jResultAxis
implements JROlapResultAxis {
    private List<Olap4jTuple> tuples;
    private List<Olap4jHierarchy> hierarchies;
    private Olap4jHierarchy[] hierarchyArray = null;

    public Olap4jResultAxis(CellSetAxis axis, List<Hierarchy> axisHierarchies, Olap4jFactory factory) {
        List positions = axis.getPositions();
        this.tuples = new ArrayList<Olap4jTuple>(positions.size());
        Iterator<Object> it = positions.iterator();
        while (it.hasNext()) {
            this.tuples.add(new Olap4jTuple((Position)it.next(), factory));
        }
        this.hierarchies = new ArrayList<Olap4jHierarchy>(axisHierarchies.size());
        it = axisHierarchies.iterator();
        while (it.hasNext()) {
            this.hierarchies.add(new Olap4jHierarchy((Hierarchy)it.next()));
        }
    }

    @Override
    public JROlapHierarchy[] getHierarchiesOnAxis() {
        return this.ensureHierarchyArray();
    }

    @Override
    public JROlapMemberTuple getTuple(int index) {
        if (index < 0 || index >= this.tuples.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.tuples.size());
        }
        return this.tuples.get(index);
    }

    @Override
    public int getTupleCount() {
        return this.tuples.size();
    }

    protected Olap4jHierarchy[] ensureHierarchyArray() {
        if (this.hierarchyArray == null) {
            this.hierarchyArray = new Olap4jHierarchy[this.hierarchies.size()];
            this.hierarchyArray = this.hierarchies.toArray(this.hierarchyArray);
        }
        return this.hierarchyArray;
    }
}

