/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.CharacterData;
import org.passay.PasswordData;
import org.passay.PasswordUtils;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class CharacterRule
implements Rule {
    protected final CharacterData characterData;
    protected int numCharacters = 1;

    public CharacterRule(CharacterData data) {
        this(data, 1);
    }

    public CharacterRule(CharacterData data, int num) {
        this.setNumberOfCharacters(num);
        this.characterData = data;
    }

    public void setNumberOfCharacters(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacters = n;
    }

    public int getNumberOfCharacters() {
        return this.numCharacters;
    }

    public CharacterData getCharacterData() {
        return this.characterData;
    }

    public String getValidCharacters() {
        return this.characterData.getCharacters();
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        String matchingChars = PasswordUtils.getMatchingCharacters(String.valueOf(this.characterData.getCharacters()), passwordData.getPassword(), this.numCharacters);
        if (matchingChars.length() < this.numCharacters) {
            return new RuleResult(false, new RuleResultDetail(this.characterData.getErrorCode(), this.createRuleResultDetailParameters(matchingChars)));
        }
        return new RuleResult(true);
    }

    protected Map<String, Object> createRuleResultDetailParameters(String matchingChars) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("minimumRequired", this.numCharacters);
        m.put("matchingCharacterCount", matchingChars.length());
        m.put("validCharacters", String.valueOf(this.characterData.getCharacters()));
        m.put("matchingCharacters", matchingChars);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::characterData=%s,numberOfCharacters=%s", this.getClass().getName(), this.hashCode(), this.characterData, this.numCharacters);
    }
}

