/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import org.passay.CharacterSequence;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;
import org.passay.SequenceData;

public class IllegalSequenceRule
implements Rule {
    public static final int DEFAULT_SEQUENCE_LENGTH = 5;
    public static final int MINIMUM_SEQUENCE_LENGTH = 3;
    protected final SequenceData sequenceData;
    protected int sequenceLength;
    protected boolean wrapSequence;
    protected boolean reportAllFailures;

    public IllegalSequenceRule(SequenceData data) {
        this(data, 5, false, true);
    }

    public IllegalSequenceRule(SequenceData data, int sl, boolean wrap) {
        this(data, sl, wrap, true);
    }

    public IllegalSequenceRule(SequenceData data, int sl, boolean wrap, boolean reportAll) {
        if (sl < 3) {
            throw new IllegalArgumentException(String.format("sequence length must be >= %s", 3));
        }
        this.sequenceData = data;
        this.sequenceLength = sl;
        this.wrapSequence = wrap;
        this.reportAllFailures = reportAll;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public SequenceData getSequenceData() {
        return this.sequenceData;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String password = passwordData.getPassword();
        int max = password.length() - this.sequenceLength + 1;
        for (int i = 0; i < this.sequenceData.getSequences().length; ++i) {
            for (int j = 0; j < max; ++j) {
                char c;
                SequenceIterator sequence = this.newSequenceIterator(this.sequenceData.getSequences()[i], password.charAt(j));
                if (sequence == null) continue;
                int position = j;
                while (sequence.forward() && sequence.matches(c = password.charAt(++position))) {
                    sequence.addMatchCharacter(c);
                }
                if (sequence.matchCount() == this.sequenceLength) {
                    this.recordFailure(result, sequence.matchString());
                }
                sequence.reset();
                position = j;
                while (sequence.backward() && sequence.matches(c = password.charAt(++position))) {
                    sequence.addMatchCharacter(c);
                }
                if (sequence.matchCount() != this.sequenceLength) continue;
                this.recordFailure(result, sequence.matchString());
            }
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::length=%d,wrap=%s,reportAllFailures=%s", this.getClass().getName(), this.hashCode(), this.sequenceLength, this.wrapSequence, this.reportAllFailures);
    }

    private SequenceIterator newSequenceIterator(CharacterSequence sequence, char first) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!sequence.matches(i, first)) continue;
            SequenceIterator s = new SequenceIterator(sequence, i, this.sequenceLength, this.wrapSequence);
            s.addMatchCharacter(first);
            return s;
        }
        return null;
    }

    private void recordFailure(RuleResult result, String match) {
        if (this.reportAllFailures || result.getDetails().isEmpty()) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            m.put("sequence", match);
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(this.sequenceData.getErrorCode(), m));
        }
    }

    private class SequenceIterator {
        private final CharacterSequence illegal;
        private final int start;
        private final int length;
        private int ubound;
        private int lbound;
        private int position;
        private final StringBuilder matches;

        SequenceIterator(CharacterSequence sequence, int startIndex, int count, boolean wrap) {
            this.illegal = sequence;
            this.start = startIndex;
            this.length = count;
            this.lbound = this.start - this.length;
            this.ubound = this.start + this.length;
            if (this.lbound < -1 && !wrap) {
                this.lbound = -1;
            }
            if (this.ubound >= sequence.length() && !wrap) {
                this.ubound = sequence.length();
            }
            this.position = this.start;
            this.matches = new StringBuilder(this.length);
        }

        public boolean forward() {
            return ++this.position < this.ubound;
        }

        public boolean backward() {
            return --this.position > this.lbound;
        }

        public void reset() {
            this.position = this.start;
            this.matches.delete(1, this.length);
        }

        public boolean matches(char c) {
            int i = this.position < 0 ? this.illegal.length() + this.position : (this.position >= this.illegal.length() ? this.position - this.illegal.length() : this.position);
            return this.illegal.matches(i, c);
        }

        public void addMatchCharacter(char c) {
            this.matches.append(c);
        }

        public int matchCount() {
            return this.matches.length();
        }

        public String matchString() {
            return this.matches.toString();
        }
    }
}

