/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.MatchBehavior;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class UsernameRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_USERNAME";
    public static final String ERROR_CODE_REVERSED = "ILLEGAL_USERNAME_REVERSED";
    private boolean matchBackwards;
    private boolean ignoreCase;
    private final MatchBehavior matchBehavior;

    public UsernameRule() {
        this(false, false, MatchBehavior.Contains);
    }

    public UsernameRule(MatchBehavior behavior) {
        this(false, false, behavior);
    }

    public UsernameRule(boolean mb, boolean ic) {
        this(mb, ic, MatchBehavior.Contains);
    }

    public UsernameRule(boolean mb, boolean ic, MatchBehavior behavior) {
        this.matchBackwards = mb;
        this.ignoreCase = ic;
        this.matchBehavior = behavior;
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String user = passwordData.getUsername();
        if (user != null && !"".equals(user)) {
            String text = passwordData.getPassword();
            String reverseUser = new StringBuilder(user).reverse().toString();
            if (this.ignoreCase) {
                text = text.toLowerCase();
                user = user.toLowerCase();
                reverseUser = reverseUser.toLowerCase();
            }
            if (this.matchBehavior.match(text, user)) {
                result.setValid(false);
                result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(user)));
            }
            if (this.matchBackwards && this.matchBehavior.match(text, reverseUser)) {
                result.setValid(false);
                result.getDetails().add(new RuleResultDetail(ERROR_CODE_REVERSED, this.createRuleResultDetailParameters(user)));
            }
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(String username) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("username", username);
        m.put("matchBehavior", (Object)this.matchBehavior);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::ignoreCase=%s,matchBackwards=%s,matchBehavior=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.ignoreCase, this.matchBackwards, this.matchBehavior});
    }
}

