/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ArgumentInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitiatorInfo
extends ArgumentInfo {
    private Object _init;

    public InitiatorInfo(Class<? extends Initiator> cls, Map<String, String> args) {
        super(args);
        InitiatorInfo.checkClass(cls);
        this._init = cls;
    }

    public InitiatorInfo(String clsnm, Map<String, String> args) throws ClassNotFoundException {
        super(args);
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (clsnm.indexOf("${") < 0) {
            if (clsnm.indexOf(46) >= 0) {
                try {
                    Class cls = Classes.forNameByThread((String)clsnm);
                    InitiatorInfo.checkClass(cls);
                    this._init = cls;
                }
                catch (ClassNotFoundException ex) {
                    throw new ClassNotFoundException("Class not found: " + clsnm, ex);
                }
            } else {
                this._init = clsnm;
            }
        } else {
            this._init = new ExValue(clsnm, String.class);
        }
    }

    public InitiatorInfo(Initiator init, Map<String, String> args) {
        super(args);
        if (init == null) {
            throw new IllegalArgumentException("null");
        }
        this._init = init;
    }

    private static void checkClass(Class<?> cls) {
        if (!Initiator.class.isAssignableFrom(cls)) {
            throw new UiException(Initiator.class + " must be implemented: " + cls);
        }
    }

    public Initiator newInitiator(PageDefinition pgdef, Page page) throws Exception {
        return this.newInitiator(pgdef.getEvaluator(), page);
    }

    public Initiator newInitiator(Evaluator eval, Page page) throws Exception {
        Class<?> cls;
        if (this._init instanceof Initiator) {
            return this.doInit((Initiator)this._init, eval, page);
        }
        String clsnm = null;
        if (this._init instanceof ExValue) {
            clsnm = (String)((ExValue)this._init).getValue(eval, page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
        } else if (this._init instanceof String) {
            clsnm = (String)this._init;
        }
        if (clsnm != null) {
            try {
                cls = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
                InitiatorInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._init + ")", ex);
            }
            if (clsnm.equals(this._init)) {
                this._init = cls;
            }
        } else {
            cls = (Class<?>)this._init;
        }
        return this.doInit((Initiator)cls.newInstance(), eval, page);
    }

    private Initiator doInit(Initiator init, Evaluator eval, Page page) throws Exception {
        Map<String, Object> args = this.resolveArguments(eval, page);
        init.doInit(page, args);
        return init;
    }
}

